@ignore

This file documents the end user interface to the GNU command line
editing feautres.  It is to be an appendix to manuals for programs which
use these features.  There is a document entitled "readline.texinfo"
which contains both end-user and programmer documentation for the GNU
Readline Library.

Copyright (C) 1988 Free Software Foundation, Inc.

Authored by Brian Fox.

Permission is granted to process this file through Tex and print the
results, provided the printed document carries copying permission notice
identical to this one except for the removal of this paragraph (this
paragraph not being relevant to the printed manual).

Permission is granted to make and distribute verbatim copies of this manual
provided the copyright notice and this permission notice are preserved on
all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided also that the
GNU Copyright statement is available to the distributee, and provided that
the entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this manual
into another language, under the above conditions for modified versions.
@end ignore

@node Command Line Editing, , , Top
@appendix Command Line Editing

This appendix describes GNU's command line editing interface.

@menu
* Introduction and Notation::	Notation used in this appendix.
* Basic Line Editing::		The minimum set of commands for editing a line.
* Movement Commands::		Commands for moving the cursor about the line.
* Cutting and Pasting::		Deletion and copying of text sections.
* Transposition::		Exchanging two characters or words.
* Completion::			Expansion of a partially typed word into
				 the full text.
@end menu

@node Introduction and Notation, Basic Line Editing, Command Line Editing, Command Line Editing
@section Introduction to Line Editing

In this appendix a the following notation is used to describe
keystrokes.

The text @key{C-k} is read as `Control-K' and describes the character
produced when the Control key is depressed and the @key{k} key is struck.

The text @key{M-k} is read as `Meta-K' and describes the character
produced when the meta key (if you have one) is depressed, and the @key{k}
key is struck.  If you do not have a meta key, the identical keystroke
can be generated by typing @key{ESC} @i{first}, and then typing @key{k}.
Either process is known as @dfn{metafying} the @key{k} key.

The text @key{M-C-k} is read as `Meta-Control-k' and describes the
character produced by @dfn{metafying} @key{C-k}.

In addition, several keys have their own names.  Specifically,
@key{DEL}, @key{ESC}, @key{LFD}, @key{SPC}, @key{RET}, and @key{TAB} all
stand for themselves when seen in this text, or in an init file
(@pxref{Readline Init File}, for more info).

@node Readline Interaction, Readline Init File, Readline Introduction, Readline Top
@section Readline Interaction
@cindex interaction, readline

Often during an interactive session you will type in a long line of
text, only to notice that the first word on the line is misspelled.  The
Readline library gives you a set of commands for manipulating the text
as you type it in, allowing you to just fix your typo, and not forcing
you to retype the majority of the line.  Using these editing commands,
you move the cursor to the place that needs correction, and delete or
insert the text of the corrections.  Then, when you are satisfied with
the line, you simply press @key{RETURN}.  You do not have to be at the
end of the line to press @key{RETURN}; the entire line will be accepted
in any case.

@menu
* Readline Bare Essentials::	The least you need to know about Readline.
* Readline Movement Commands::	Moving about the input line.
* Readline Killing Commands::	How to delete text, and how to get it back!
* Readline Arguments::		Giving numeric arguments to commands.
@end menu

@node Readline Bare Essentials, Readline Movement Commands, Readline Interaction, Readline Interaction
@subsection Readline Bare Essentials

In order to enter characters into the line, simply type them.  The typed
character appears where the cursor was, and then the cursor moves one
space to the right.  If you mistype a character, you can use @key{DEL} to
back up, and delete the mistyped character.

Sometimes you may miss typing a character that you wanted to type, and
not notice your error until you have typed several other characters.  In
that case, you can type @key{C-b} to move the cursor to the left, and then
correct your mistake.  Aftwerwards, you can move the cursor to the right
with @key{C-f}.

When you add text in the middle of a line, you will notice that characters
to the right of the cursor get `pushed over' to make room for the text
that you have inserted.  Likewise, when you delete text behind the cursor,
characters to the right of the cursor get `pulled back' to fill in the
blank space created by the removal of the text.  A list of the basic bare
essentials for editing the text of an input line follows.

@table @asis
@item @key{C-b}
Move back one character.
@item @key{C-f}
Move forward one character.
@item @key{DEL}
Delete the character to the left of the cursor.
@item @key{C-d}
Delete the character underneath the cursor.
@item @w{Printing characters}
Insert itself into the line at the cursor.
@item @key{C-_}
Undo the last thing that you did.  You can undo all the way back to an
empty line.
@end table

@node Readline Movement Commands, Readline Killing Commands, Readline Bare Essentials, Readline Interaction
@subsection Readline Movement Commands


The above table describes the most basic possible keystrokes that you need
in order to do editing of the input line.  For your convenience, many
other commands have been added in addition to @key{C-b}, @key{C-f},
@key{C-d}, and @key{DEL}.  Here are some commands for moving more rapidly
about the line.

@table @key
@item C-a
Move to the start of the line.
@item C-e
Move to the end of the line.
@item M-f
Move forward a word.
@item M-b
Move backward a word.
@item C-l
Clear the screen, reprinting the current line at the top.
@end table

Notice how @key{C-f} moves forward a character, while @key{M-f} moves
forward a word.  It is a loose convention that control keystrokes
operate on characters while meta keystrokes operate on words.

@node Readline Killing Commands, Readline Arguments, Readline Movement Commands, Readline Interaction
@subsection Readline Killing Commands

The act of @dfn{cutting} text means to delete the text from the line, and
to save away the deleted text for later use, just as if you had cut the
text out of the line with a pair of scissors.  There is a

@dfn{Killing} text means to delete the text from the line, but to save
it away for later use, usually by @dfn{yanking} it back into the line.
If the description for a command says that it `kills' text, then you can
be sure that you can get the text back in a different (or the same)
place later.

Here is the list of commands for killing text.

@table @key
@item C-k
Kill the text from the current cursor position to the end of the line.

@item M-d
Kill from the cursor to the end of the current word, or if between
words, to the end of the next word.

@item M-DEL
Kill fromthe cursor the start ofthe previous word, or if between words, to the start of the previous word.

@item C-w
Kill from the cursor to the previous whitespace.  This is different than
@key{M-DEL} because the word boundaries differ.

@end table

And, here is how to @dfn{yank} the text back into the line.  Yanking
is

@table @key
@item C-y
Yank the most recently killed text back into the buffer at the cursor.

@item M-y
Rotate the kill-ring, and yank the new top.  You can only do this if
the prior command is @key{C-y} or @key{M-y}.
@end table

When you use a kill command, the text is saved in a @dfn{kill-ring}.
Any number of consecutive kills save all of the killed text together, so
that when you yank it back, you get it in one clean sweep.  The kill
ring is not line specific; the text that you killed on a previously
typed line is available to be yanked back later, when you are typing
another line.

@node Readline Arguments, , Readline Killing Commands, Readline Interaction
@subsection Readline Arguments

You can pass numeric arguments to Readline commands.  Sometimes the
argument acts as a repeat count, other times it is the @i{sign} of the
argument that is significant.  If you pass a negative argument to a
command which normally acts in a forward direction, that command will
act in a backward direction.  For example, to kill text back to the
start of the line, you might type @key{M--} @key{C-k}.

The general way to pass numeric arguments to a command is to type meta
digits before the command.  If the first `digit' you type is a minus
sign (@key{-}), then the sign of the argument will be negative.  Once
you have typed one meta digit to get the argument started, you can type
the remainder of the digits, and then the command.  For example, to give
the @key{C-d} command an argument of 10, you could type @key{M-1 0 C-d}.


@node Readline Init File, , Readline Interaction, Readline Top
@section Readline Init File

Although the Readline library comes with a set of Emacs-like
keybindings, it is possible that you would like to use a different set
of keybindings.  You can customize programs that use Readline by putting
commands in an @dfn{init} file in your home directory.  The name of this
file is @file{~/.inputrc}.

When a program which uses the Readline library starts up, the
@file{~/.inputrc} file is read, and the keybindings are set.

@menu
* Readline Init Syntax::	Syntax for the commands in @file{~/.inputrc}.
* Readline Vi Mode::		Switching to @code{vi} mode in Readline.
@end menu

@node Readline Init Syntax, Readline Vi Mode, Readline Init File, Readline Init File
@subsection Readline Init Syntax

You can start up with a vi-like editing mode by placing

@example
@code{set editing-mode vi}
@end example

in your @file{~/.inputrc} file.

You can have Readline use a single line for display, scrolling the input
between the two edges of the screen by placing

@example
@code{set horizontal-scroll-mode On}
@end example

in your @file{~/.inputrc} file.

The syntax for controlling keybindings in the @file{~/.inputrc} file is
simple.  First you have to know the @i{name} of the command that you
want to change.  The following pages contain tables of the command name, the
default keybinding, and a short description of what the command does.

Once you know the name of the command, simply place the name of the key
you wish to bind the command to, a colon, and then the name of the
command on a line in the @file{~/.inputrc} file.  Here is an example:

@example
# This is a comment line.
Meta-Rubout:	backward-kill-word
Control-u:	universal-argument
@end example

@menu
* Commands For Moving::		Moving about the line.
* Commands For History::	Getting at previous lines.
* Commands For Text::		Commands for changing text.
* Commands For Killing::	Commands for killing and yanking.
* Numeric Arguments::		Specifying numeric arguments, repeat counts.
* Commands For Completion::	Getting Readline to do the typing for you.
* Miscellaneous Commands::	Other miscillaneous commands.
@end menu

@node Commands For Moving, Commands For History, Readline Init Syntax, Readline Init Syntax
@subsubsection Commands For Moving
@table @code
@item beginning-of-line (C-a)
Move to the start of the current line.

@item end-of-line (C-e)
Move to the end of the line.

@item forward-char (C-f)
Move forward a character.

@item backward-char (C-b)
Move back a character.

@item forward-word (M-f)
Move forward to the end of the next word.

@item backward-word (M-b)
Move back to the start of this, or the previous, word.

@item clear-screen (C-l)
Clear the screen leaving the current line at the top of the screen.

@end table

@node Commands For History, Commands For Text, Commands For Moving, Readline Init Syntax
@subsubsection Commands For Manipulating The History

@table @code
@item accept-line (Newline, Return)
Accept the line regardless of where the cursor is.  If this line is
non-empty, add it too the history list.  If this line was a history
line, then restore the history line to its original state.

@item previous-history (C-p)
Move `up' through the history list.

@item next-history (C-n)
Move `down' through the history list.

@item beginning-of-history (M-<)
Move to the first line in the history.

@item end-of-history (M->)
Move to the end of the input history, i.e., the line you are entering!

@item reverse-search-history (C-r)
Search backward starting at the current line and moving `up' through
the history as necessary.  This is an incremental search.

@item forward-search-history (C-s)
Search forward starting at the current line and moving `down' through
the the history as neccessary.

@end table

@node Commands For Text, Commands For Killing, Commands For History, Readline Init Syntax
@subsubsection Commands For Changing Text

@table @code
@item delete-char (C-d)
Delete the character under the cursor.  If the cursor is at the
beginning of the line, and there are no characters in the line, and
the last character typed was not C-d, then return EOF.

@item backward-delete-char (Rubout)
Delete the character behind the cursor.  A numeric arg says to kill
the characters instead of deleting them.

@item quoted-insert (C-q, C-v)
Add the next character that you type to the line verbatim.  This is
how to insert things like C-q for example.

@item tab-insert (M-TAB)
Insert a tab character.

@item self-insert (a, b, A, 1, !, ...)
Insert yourself.

@item transpose-chars (C-t)
Drag the character before point forward over the character at point.
Point moves forward as well.  If point is at the end of the line, then
transpose the two characters before point.  Negative args don't work.

@item transpose-words (M-t)
Drag the word behind the cursor past the word in front of the cursor
moving the cursor over that word as well.

@item upcase-word (M-u)
Uppercase the current (or following) word.  With a negative argument,
do the previous word, but do not move point.

@item downcase-word (M-l)
Lowercase the current (or following) word.  With a negative argument,
do the previous word, but do not move point.

@item capitalize-word (M-c)
Uppercase the current (or following) word.  With a negative argument,
do the previous word, but do not move point.

@end table

@node Commands For Killing, Numeric Arguments, Commands For Text, Readline Init Syntax
@subsubsection Killing And Yanking

@table @code

@item kill-line (C-k)
Kill the text from the current cursor position to the end of the line.

@item backward-kill-line ()
Kill backward to the beginning of the line.  This is normally unbound.

@item kill-word (M-d)
Kill from the cursor to the end of the current word, or if between
words, to the end of the next word.

@item backward-kill-word (M-DEL)
Kill the word behind the cursor.

@item unix-line-discard (C-u)
Do what C-u used to do in Unix line input.  We save the killed text on
the kill-ring, though.

@item unix-word-rubout (C-w)
Do what C-w used to do in Unix line input.  The killed text is saved
on the kill-ring.  This is different than backward-kill-word because
the word boundaries differ.

@item yank (C-y)
Yank the top of the kill ring into the buffer at point.

@item yank-pop (M-y)
Rotate the kill-ring, and yank the new top.  You can only do this if
the prior command is yank or yank-pop.
@end table

@node Numeric Arguments, Commands For Completion, Commands For Killing, Readline Init Syntax
@subsubsection Specifying Numeric Arguments
@table @code

@item digit-argument (M-0, M-1, ... M--)
Add this digit to the argument already accumulating, or start a new
argument.  M-- starts a negative argument.

@item universal-argument ()
Do what C-u does in emacs.  By default, this is not bound.
@end table


@node Commands For Completion, Miscellaneous Commands, Numeric Arguments, Readline Init Syntax
@subsubsection Letting Readline Type For You

@table @code
@item complete (TAB)
Attempt to do completion on the text before point.  This is
implementation defined.  Generally, if you are typing a filename
argument, you can do filename completion; if you are typing a command,
you can do command completion, if you are typing in a symbol to GDB, you
can do symbol name completion, if you are typing in a variable to Bash,
you can do variable name completion...

@item possible-completions (M-?)
List the possible completions of the text before point.
@end table

@node Miscellaneous Commands, , Commands For Completion, Readline Init Syntax
@subsubsection Some Miscellaneous Commands
@table @code

@item abort (C-g)
Ding!  Stops things.

@item do-uppercase-version (M-a, M-b, ...)
Run the command that is bound to your uppercase brother.

@item prefix-meta (ESC)
Make the next character that you type be metafied.  This is for
people without a meta key.  @key{ESC-f} is equivalent to @key{M-f}.

@item undo (C-_)
Incremental undo, separately remembered for each line.

@item revert-line (M-r)
Undo all changes made to this line.  This is like typing the `undo'
command enough times to get back to the beginning.
@end table

@node Readline Vi Mode, , Readline Init Syntax, Readline Init File
@subsection Readline Vi Mode

While the Readline library does not have a full set of Vi editing
functions, it does contain enough to allow simple editing of the line.

In order to switch interactively between Emacs and Vi editing modes, use
the command M-C-j (toggle-editing-mode).

When you enter a line in Vi mode, you are already placed in `insertion'
mode, as if you had typed an `i'.  Pressing @key{ESC} switches you into
`edit' mode, where you can edit the text of the line with the standard
Vi movement keys, move to previous history lines with `k', and following
lines with `j', and so forth.




