/*****************************************************************************
 * addressbar.cpp
 *****************************************************************************
 * Copyright (C) 2022 MX Authors
 *
 * Authors: Adrian <adrian@mxlinux.org>
 *          MX Linux <http://mxlinux.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * MX Viewer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MX Viewer.  If not, see <http://www.gnu.org/licenses/>.
 ****************************************************************************/
#include "addressbar.h"
#include <QKeyEvent>
#include <QTimer>

AddressBar::AddressBar(QWidget *parent)
    : QLineEdit(parent)
{
}

void AddressBar::focusInEvent(QFocusEvent *event)
{
    QLineEdit::focusInEvent(event);
    emit focused();
    if (event->reason() == Qt::PopupFocusReason) {
        return;
    }
    selectAllPending = true;
    QTimer::singleShot(0, this, [this] {
        if (selectAllPending) {
            selectAll();
        }
    });
}

void AddressBar::keyPressEvent(QKeyEvent *event)
{
    selectAllPending = false;
    emit keyPressed(event->key());
    QLineEdit::keyPressEvent(event);
}
