/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class TeXFloatingPoint
extends AbstractTeXObject
implements TeXNumber {
    private double value;
    public static final TeXFloatingPoint MINUS_ONE = new TeXFloatingPoint(-1.0);
    public static final TeXFloatingPoint ZERO = new TeXFloatingPoint(0.0);
    public static final TeXFloatingPoint ONE = new TeXFloatingPoint(1.0);

    public TeXFloatingPoint() {
        this(0.0);
    }

    public TeXFloatingPoint(double d) {
        this.value = d;
    }

    public TeXFloatingPoint(TeXParser teXParser, String string) throws TeXSyntaxException {
        try {
            this.value = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", string);
        }
    }

    @Override
    public Object clone() {
        return new TeXFloatingPoint(this.value);
    }

    @Override
    public boolean isDataObject() {
        return true;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.getValue();
    }

    @Override
    public int getValue() {
        return (int)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public void setValue(float f) {
        this.value = f;
    }

    @Override
    public void multiply(int n) {
        this.value *= (double)n;
    }

    @Override
    public void divide(int n) {
        this.value /= (double)n;
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        if (numerical instanceof TeXNumber) {
            this.advance((TeXNumber)numerical);
        } else {
            this.value += (double)numerical.number(teXParser);
        }
    }

    public void advance(TeXNumber teXNumber) throws TeXSyntaxException {
        this.value += teXNumber.doubleValue();
    }

    public void advance() {
        this.value += 1.0;
    }

    public void add(double d) {
        this.value += d;
    }

    public void subtract(double d) {
        this.value -= d;
    }

    public void multiple(double d) {
        this.value *= d;
    }

    public void divide(double d) {
        this.value /= d;
    }

    @Override
    public String format() {
        return "" + this.value;
    }

    public String toString() {
        return String.format("%s[value=%f]", this.getClass().getSimpleName(), this.value);
    }

    @Override
    public String toString(TeXParser teXParser) {
        return "" + this.value;
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.string(this.toString(teXParser));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().write("" + this.value);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }
}

