/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.messaging.context.navigate.SAMLMessageContextIssuerFunction;
import org.opensaml.saml.saml2.core.Artifact;
import org.opensaml.saml.saml2.core.ArtifactResolve;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.slf4j.Logger;

public class ResolveArtifact
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ResolveArtifact.class);
    @Nonnull
    private Function<ProfileRequestContext, ArtifactResolve> requestLookupStrategy = new MessageLookup<ArtifactResolve>(ArtifactResolve.class).compose(new InboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, ArtifactResponse> responseLookupStrategy = new MessageLookup<ArtifactResponse>(ArtifactResponse.class).compose(new OutboundMessageContextLookup());
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> requesterLookupStrategy = new SAMLMessageContextIssuerFunction().compose(new InboundMessageContextLookup());
    @NonnullAfterInit
    private SAMLArtifactMap artifactMap;
    @NonnullBeforeExec
    private String artifact;
    @NonnullBeforeExec
    private ArtifactResponse response;
    @NonnullBeforeExec
    private String issuerId;
    @NonnullBeforeExec
    private String requesterId;

    public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, ArtifactResolve> strategy) {
        this.checkSetterPreconditions();
        this.requestLookupStrategy = Constraint.isNotNull(strategy, "Request lookup strategy cannot be null");
    }

    public void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, ArtifactResponse> strategy) {
        this.checkSetterPreconditions();
        this.responseLookupStrategy = Constraint.isNotNull(strategy, "Response lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = Constraint.isNotNull(strategy, "Issuer lookup strategy cannot be null");
    }

    public void setRequesterLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.requesterLookupStrategy = Constraint.isNotNull(strategy, "Requester lookup strategy cannot be null");
    }

    public void setArtifactMap(@Nonnull SAMLArtifactMap map) {
        this.checkSetterPreconditions();
        this.artifactMap = Constraint.isNotNull(map, "SAMLArtifactMap cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.artifactMap == null) {
            throw new ComponentInitializationException("SAMLArtifactMap cannot be null");
        }
        if (this.issuerLookupStrategy == null) {
            throw new ComponentInitializationException("Issuer lookup strategy cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        ArtifactResolve request = this.requestLookupStrategy.apply(profileRequestContext);
        if (request == null) {
            this.log.debug("{} No request located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return false;
        }
        Artifact artifactObject = request.getArtifact();
        String string = this.artifact = artifactObject != null ? artifactObject.getValue() : null;
        if (this.artifact == null) {
            this.log.debug("{} No Artifact found in request, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return false;
        }
        this.response = this.responseLookupStrategy.apply(profileRequestContext);
        if (this.response == null) {
            this.log.debug("{} No response located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return false;
        }
        this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        if (this.issuerId == null) {
            this.log.debug("{} No issuer identity located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidProfileContext");
            return false;
        }
        this.requesterId = this.requesterLookupStrategy.apply(profileRequestContext);
        if (this.requesterId == null) {
            this.log.debug("{} No requester identity located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SAMLArtifactMap.SAMLArtifactMapEntry entry = null;
        try {
            entry = this.artifactMap.get(this.artifact);
        }
        catch (IOException e) {
            this.log.error("{} Error resolving artifact", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent(profileRequestContext, "UnableToResolveArtifact");
            return;
        }
        if (entry == null) {
            this.log.warn("{} Unresolvable Artifact '{}' from relying party '{}'", new Object[]{this.getLogPrefix(), this.artifact, this.requesterId});
            ActionSupport.buildEvent(profileRequestContext, "UnableToResolveArtifact");
            return;
        }
        try {
            this.artifactMap.remove(this.artifact);
        }
        catch (IOException e) {
            this.log.error("{} Error removing artifact from map", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent(profileRequestContext, "UnableToResolveArtifact");
            return;
        }
        if (!entry.getIssuerId().equals(this.issuerId)) {
            this.log.warn("{} Artifact issuer mismatch, issued by '{}' but IdP has entityID of '{}'", new Object[]{this.getLogPrefix(), entry.getIssuerId(), this.issuerId});
            ActionSupport.buildEvent(profileRequestContext, "UnableToResolveArtifact");
        } else if (!entry.getRelyingPartyId().equals(this.requesterId)) {
            this.log.warn("{} Artifact relying party mismatch, issued to '{}' but requested by '{}'", new Object[]{this.getLogPrefix(), entry.getRelyingPartyId(), this.requesterId});
            ActionSupport.buildEvent(profileRequestContext, "UnableToResolveArtifact");
        } else {
            this.response.setMessage(entry.getSamlMessage());
        }
    }
}

