/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.lucene;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.Encoder;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.Parameter;
import org.opensearch.knn.index.mapper.CompressionLevel;

public class LuceneSQEncoder
implements Encoder {
    private static final Set<VectorDataType> SUPPORTED_DATA_TYPES = ImmutableSet.of((Object)((Object)VectorDataType.FLOAT));
    private static final List<Integer> LUCENE_SQ_BITS_SUPPORTED = List.of(Integer.valueOf(7));
    private static final MethodComponent METHOD_COMPONENT = MethodComponent.Builder.builder("sq").addSupportedDataTypes(SUPPORTED_DATA_TYPES).addParameter("confidence_interval", new Parameter.DoubleParameter("confidence_interval", null, (v, context) -> v == 0.0 || v >= 0.9 && v <= 1.0)).addParameter("bits", new Parameter.IntegerParameter("bits", 7, (v, context) -> LUCENE_SQ_BITS_SUPPORTED.contains(v))).build();

    @Override
    public MethodComponent getMethodComponent() {
        return METHOD_COMPONENT;
    }

    @Override
    public CompressionLevel calculateCompressionLevel(MethodComponentContext methodComponentContext, KNNMethodConfigContext knnMethodConfigContext) {
        return CompressionLevel.x4;
    }
}

