/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import java.util.Objects;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.inject.Inject;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.replication.checkpoint.PublishReferencedSegmentsAction;
import org.opensearch.indices.replication.checkpoint.ReferencedSegmentsCheckpoint;

@ExperimentalApi
public class ReferencedSegmentsPublisher {
    private final PublishAction publishAction;
    public static final ReferencedSegmentsPublisher EMPTY = new ReferencedSegmentsPublisher((indexShard, checkpoint) -> {});

    @Inject
    public ReferencedSegmentsPublisher(PublishReferencedSegmentsAction publishAction) {
        this(publishAction::publish);
    }

    public ReferencedSegmentsPublisher(PublishAction publishAction) {
        this.publishAction = Objects.requireNonNull(publishAction);
    }

    public void publish(IndexShard indexShard, ReferencedSegmentsCheckpoint checkpoint) {
        this.publishAction.publish(indexShard, checkpoint);
    }

    @ExperimentalApi
    public static interface PublishAction {
        public void publish(IndexShard var1, ReferencedSegmentsCheckpoint var2);
    }
}

