/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.util.Map;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;

public class CJKBigramFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "cjkBigram";
    final int flags;
    final boolean outputUnigrams;

    public CJKBigramFilterFactory(Map<String, String> args) {
        super(args);
        int flags = 0;
        if (this.getBoolean(args, "han", true)) {
            flags |= 1;
        }
        if (this.getBoolean(args, "hiragana", true)) {
            flags |= 2;
        }
        if (this.getBoolean(args, "katakana", true)) {
            flags |= 4;
        }
        if (this.getBoolean(args, "hangul", true)) {
            flags |= 8;
        }
        this.flags = flags;
        this.outputUnigrams = this.getBoolean(args, "outputUnigrams", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public CJKBigramFilterFactory() {
        throw CJKBigramFilterFactory.defaultCtorException();
    }

    public TokenStream create(TokenStream input) {
        return new CJKBigramFilter(input, this.flags, this.outputUnigrams);
    }
}

