/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ValueAndTimestamp;

public class KeyValueIteratorFacade<K, V>
implements KeyValueIterator<K, V> {
    private final KeyValueIterator<K, ValueAndTimestamp<V>> innerIterator;

    public KeyValueIteratorFacade(KeyValueIterator<K, ValueAndTimestamp<V>> iterator) {
        this.innerIterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.innerIterator.hasNext();
    }

    @Override
    public K peekNextKey() {
        return this.innerIterator.peekNextKey();
    }

    @Override
    public KeyValue<K, V> next() {
        KeyValue innerKeyValue = (KeyValue)this.innerIterator.next();
        return KeyValue.pair(innerKeyValue.key, ValueAndTimestamp.getValueOrNull((ValueAndTimestamp)innerKeyValue.value));
    }

    @Override
    public void close() {
        this.innerIterator.close();
    }
}

