/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.data;

import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.DoubleRange;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.filesleuth.data.LocationFilter;

public class TrackBounds {
    private final DoubleRange _latitudeRange = new DoubleRange();
    private final DoubleRange[] _longitudeRanges = new DoubleRange[36];

    public TrackBounds() {
        int n = 0;
        while (n < this._longitudeRanges.length) {
            this._longitudeRanges[n] = new DoubleRange();
            ++n;
        }
    }

    public void addPoint(DataPoint dataPoint) {
        this.addCoordinates(dataPoint.getLatitude().getDouble(), dataPoint.getLongitude().getDouble());
    }

    public void addCoordinates(double d, double d2) {
        this._latitudeRange.addValue(d);
        int n = TrackBounds.getPocket(d2);
        this._longitudeRanges[n].addValue(d2);
    }

    private static int getPocket(double d) {
        return (int)(d + 180.0) / 10;
    }

    public boolean includesPoint(DataPoint dataPoint) {
        return this.includesPoint(dataPoint, 0.0);
    }

    public boolean includesPoint(DataPoint dataPoint, double d) {
        double d2 = dataPoint.getLatitude().getDouble();
        return this.isLatitudeInRange(d2, d) && this.isLongitudeInRange(dataPoint.getLongitude().getDouble(), d2, d);
    }

    boolean isLatitudeInRange(double d, double d2) {
        if (this._latitudeRange.includes(d)) {
            return true;
        }
        double d3 = d < this._latitudeRange.getMinimum() ? Distance.calculateRadiansBetween(d, 0.0, this._latitudeRange.getMinimum(), 0.0) : Distance.calculateRadiansBetween(d, 0.0, this._latitudeRange.getMaximum(), 0.0);
        double d4 = Distance.convertRadiansToDistance(d3, UnitSetLibrary.UNITS_METRES);
        return d4 < d2;
    }

    boolean isLongitudeInRange(double d, double d2, double d3) {
        DoubleRange[] doubleRangeArray = this._longitudeRanges;
        int n = this._longitudeRanges.length;
        int n2 = 0;
        while (n2 < n) {
            DoubleRange doubleRange = doubleRangeArray[n2];
            if (doubleRange.hasData()) {
                double d4;
                if (doubleRange.includes(d)) {
                    return true;
                }
                double d5 = Distance.calculateRadiansBetween(d2, d, d2, doubleRange.getMinimum());
                double d6 = Math.min(d5, d4 = Distance.calculateRadiansBetween(d2, d, d2, doubleRange.getMaximum()));
                double d7 = Distance.convertRadiansToDistance(d6, UnitSetLibrary.UNITS_METRES);
                if (d7 < d3) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public boolean overlaps(LocationFilter locationFilter) {
        return locationFilter == null || locationFilter.getPoint() == null || this.includesPoint(locationFilter.getPoint(), locationFilter.getDistanceInMetres());
    }
}

