/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;

public class XmlProgramUtilities {
    public static String toString(Address addr) {
        AddressSpace space = addr.getAddressSpace();
        if (space instanceof OverlayAddressSpace) {
            OverlayAddressSpace oSpace = (OverlayAddressSpace)space;
            return oSpace.toString() + oSpace.getOverlayedSpace().toString() + addr.toString(false);
        }
        return addr.toString();
    }

    public static Address parseAddress(AddressFactory factory, String addrString) {
        int index;
        if (addrString == null) {
            return null;
        }
        Address addr = factory.getAddress(addrString);
        if (addr == null && (index = addrString.indexOf("::")) > 0) {
            addr = factory.getAddress(addrString.substring(index + 2));
        }
        return addr;
    }
}

