/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.pattern;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.pattern.InstructionPattern;
import ghidra.app.plugin.processors.sleigh.pattern.Pattern;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import java.util.ArrayList;

public class OrPattern
extends Pattern {
    private DisjointPattern[] orlist;

    public OrPattern() {
        this.orlist = null;
    }

    public OrPattern(DisjointPattern a, DisjointPattern b) {
        this.orlist = new DisjointPattern[2];
        this.orlist[0] = a;
        this.orlist[1] = b;
    }

    public OrPattern(ArrayList<?> list) {
        this.orlist = new DisjointPattern[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.orlist[i] = (DisjointPattern)list.get(i);
        }
    }

    @Override
    public Pattern simplifyClone() {
        for (int i = 0; i < this.orlist.length; ++i) {
            if (!this.orlist[i].alwaysTrue()) continue;
            return new InstructionPattern(true);
        }
        ArrayList<Pattern> newlist = new ArrayList<Pattern>();
        for (int i = 0; i < this.orlist.length; ++i) {
            if (this.orlist[i].alwaysFalse()) continue;
            newlist.add(this.orlist[i].simplifyClone());
        }
        if (newlist.size() == 0) {
            return new InstructionPattern(false);
        }
        if (newlist.size() == 1) {
            return (Pattern)newlist.get(0);
        }
        return new OrPattern(newlist);
    }

    @Override
    public void shiftInstruction(int sa) {
        for (int i = 0; i < this.orlist.length; ++i) {
            this.orlist[i].shiftInstruction(sa);
        }
    }

    @Override
    public Pattern doOr(Pattern b, int sa) {
        int i;
        ArrayList<Pattern> newlist = new ArrayList<Pattern>();
        for (i = 0; i < this.orlist.length; ++i) {
            newlist.add(this.orlist[i].simplifyClone());
        }
        if (sa < 0) {
            for (i = 0; i < this.orlist.length; ++i) {
                this.orlist[i].shiftInstruction(-sa);
            }
        }
        if (b instanceof OrPattern) {
            OrPattern b2 = (OrPattern)b;
            for (int i2 = 0; i2 < b2.orlist.length; ++i2) {
                newlist.add(b2.orlist[i2].simplifyClone());
            }
        } else {
            newlist.add(b.simplifyClone());
        }
        if (sa > 0) {
            for (int i3 = 0; i3 < newlist.size(); ++i3) {
                ((Pattern)newlist.get(i3)).shiftInstruction(sa);
            }
        }
        return new OrPattern(newlist);
    }

    @Override
    public Pattern doAnd(Pattern b, int sa) {
        ArrayList<DisjointPattern> newlist = new ArrayList<DisjointPattern>();
        if (b instanceof OrPattern) {
            OrPattern b2 = (OrPattern)b;
            for (int i = 0; i < this.orlist.length; ++i) {
                for (int j = 0; j < b2.orlist.length; ++j) {
                    DisjointPattern tmp = (DisjointPattern)this.orlist[i].doAnd(b2.orlist[j], sa);
                    newlist.add(tmp);
                }
            }
        } else {
            for (int i = 0; i < this.orlist.length; ++i) {
                DisjointPattern tmp = (DisjointPattern)this.orlist[i].doAnd(b, sa);
                newlist.add(tmp);
            }
        }
        return new OrPattern(newlist);
    }

    @Override
    public boolean isMatch(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException {
        boolean match = false;
        for (int i = 0; i < this.orlist.length; ++i) {
            this.debugNextMatch(debug, i);
            if (!this.orlist[i].isMatch(walker, debug)) continue;
            match = true;
            break;
        }
        this.debugDone(debug, match);
        return match;
    }

    private void debugDone(SleighDebugLogger debug, boolean match) {
        if (debug != null) {
            debug.endPatternGroup(match);
            debug.dropIndent();
            debug.append(") " + (match ? "Matched" : "Failed") + "\n");
        }
    }

    private void debugNextMatch(SleighDebugLogger debug, int patternIndex) {
        if (debug == null) {
            return;
        }
        if (patternIndex == 0) {
            debug.append("(  ");
        } else {
            debug.endPatternGroup(false);
            debug.dropIndent();
            debug.append(") -or- (\n");
        }
        debug.startPatternGroup(null);
        debug.indent();
    }

    @Override
    public int numDisjoint() {
        return this.orlist.length;
    }

    @Override
    public DisjointPattern getDisjoint(int i) {
        return this.orlist[i];
    }

    @Override
    public boolean alwaysTrue() {
        for (int i = 0; i < this.orlist.length; ++i) {
            if (!this.orlist[i].alwaysTrue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean alwaysFalse() {
        for (int i = 0; i < this.orlist.length; ++i) {
            if (this.orlist[i].alwaysFalse()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean alwaysInstructionTrue() {
        for (int i = 0; i < this.orlist.length; ++i) {
            if (this.orlist[i].alwaysInstructionTrue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        int el = decoder.openElement(SlaFormat.ELEM_OR_PAT);
        ArrayList<DisjointPattern> ors = new ArrayList<DisjointPattern>();
        int peek = decoder.peekElement();
        while (peek != 0) {
            ors.add(DisjointPattern.decodeDisjoint(decoder));
        }
        this.orlist = new DisjointPattern[ors.size()];
        int i = 0;
        for (DisjointPattern pat : ors) {
            this.orlist[i++] = pat;
        }
        decoder.closeElement(el);
    }
}

