/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class MiddleLayout
implements LayoutManager,
Serializable {
    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Component[] components = container.getComponents();
        if (components.length == 0) {
            return new Dimension(0, 0);
        }
        Component component = components[0];
        if (component == null) {
            return new Dimension(0, 0);
        }
        Dimension size = new Dimension(component.getPreferredSize());
        Insets insets = container.getInsets();
        size.height += insets.top + insets.bottom;
        size.width += insets.left + insets.right;
        return size;
    }

    @Override
    public Dimension minimumLayoutSize(Container cont) {
        return this.preferredLayoutSize(cont);
    }

    @Override
    public void layoutContainer(Container container) {
        Component[] components = container.getComponents();
        if (components.length == 0) {
            return;
        }
        Component component = components[0];
        if (component == null) {
            return;
        }
        component.setSize(component.getPreferredSize());
        Dimension size = component.getSize();
        Dimension containerSize = container.getSize();
        Insets insets = container.getInsets();
        containerSize.width -= insets.left + insets.right;
        containerSize.height -= insets.top + insets.bottom;
        int middleTop = containerSize.height / 2 - size.height / 2;
        int middleLeft = containerSize.width / 2 - size.width / 2;
        component.setBounds(middleLeft += insets.left, middleTop += insets.top, size.width, size.height);
    }
}

