/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.add;

import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddToSessionData {
    private Program sourceProgram;
    private Program destinationProgram;
    private VTSession session;
    private AddressSetView customSourceAddressSet;
    private AddressSetView customDestinationAddressSet;
    private AddressSetView sourceSelection;
    private AddressSetView destinationSelection;
    private List<VTProgramCorrelatorFactory> correlators;
    private Map<VTProgramCorrelatorFactory, VTOptions> optionsMap = new HashMap<VTProgramCorrelatorFactory, VTOptions>();
    private boolean shouldExcludeAcceptedMatches;
    private boolean shouldLimitAddressSets;
    private AddressSetChoice sourceAddressSetChoice = AddressSetChoice.ENTIRE_PROGRAM;
    private AddressSetChoice destinationAddressSetChoice = AddressSetChoice.ENTIRE_PROGRAM;

    public void setSourceProgram(Program sourceProgram) {
        this.sourceProgram = sourceProgram;
    }

    public Program getSourceProgram() {
        return this.sourceProgram;
    }

    public void setDestinationProgram(Program destinationProgram) {
        this.destinationProgram = destinationProgram;
    }

    public Program getDestinationProgram() {
        return this.destinationProgram;
    }

    public void setSession(VTSession session) {
        this.session = session;
    }

    public VTSession getSession() {
        return this.session;
    }

    public DomainFile getSourceFile() {
        return this.sourceProgram.getDomainFile();
    }

    public DomainFile getDestinationFile() {
        return this.destinationProgram.getDomainFile();
    }

    public AddressSetChoice getSourceAddressSetChoice() {
        return this.sourceAddressSetChoice;
    }

    public AddressSetChoice getDestinationAddressSetChoice() {
        return this.destinationAddressSetChoice;
    }

    public void setSourceAddressSetChoice(AddressSetChoice choice) {
        this.sourceAddressSetChoice = choice;
    }

    public void setDestinationAddressSetChoice(AddressSetChoice choice) {
        this.destinationAddressSetChoice = choice;
    }

    public void setSourceSelection(AddressSetView addressSet) {
        this.sourceSelection = addressSet;
        if (addressSet != null && !addressSet.isEmpty()) {
            this.shouldLimitAddressSets = true;
            this.sourceAddressSetChoice = AddressSetChoice.SELECTION;
        }
    }

    public void setDestinationSelection(AddressSetView addresseSet) {
        this.destinationSelection = addresseSet;
        if (addresseSet != null && !addresseSet.isEmpty()) {
            this.shouldLimitAddressSets = true;
            this.destinationAddressSetChoice = AddressSetChoice.SELECTION;
        }
    }

    public AddressSetView getCustomSourceAddressSet() {
        return this.customSourceAddressSet;
    }

    public void setCustomSourceAddressSet(AddressSetView addressSet) {
        this.customSourceAddressSet = addressSet;
    }

    public void setCustomDestinationAddressSet(AddressSetView addressSet) {
        this.customDestinationAddressSet = addressSet;
    }

    public AddressSetView getCustomDestinationAddressSet() {
        return this.customDestinationAddressSet;
    }

    public AddressSetView getSourceSelection() {
        return this.sourceSelection;
    }

    public AddressSetView getDestinationSelection() {
        return this.destinationSelection;
    }

    public List<VTProgramCorrelatorFactory> getCorrelators() {
        return this.correlators;
    }

    public void setCorrelators(List<VTProgramCorrelatorFactory> correlators) {
        if (!correlators.equals(this.correlators)) {
            this.correlators = correlators;
            this.updateOptionsMap();
        }
    }

    private void updateOptionsMap() {
        this.optionsMap.keySet().retainAll(this.correlators);
        for (VTProgramCorrelatorFactory correlator : this.correlators) {
            VTOptions defaultOptions;
            if (this.optionsMap.containsKey(correlator) || (defaultOptions = correlator.createDefaultOptions()) == null) continue;
            this.optionsMap.put(correlator, defaultOptions);
        }
    }

    public Map<VTProgramCorrelatorFactory, VTOptions> getOptions() {
        return this.optionsMap;
    }

    public boolean shouldExcludeAcceptedMatches() {
        return this.shouldExcludeAcceptedMatches;
    }

    public void setShouldExcludeAcceptedMatches(boolean b) {
        this.shouldExcludeAcceptedMatches = b;
    }

    public boolean shouldLimitAddressSets() {
        return this.shouldLimitAddressSets;
    }

    public void setShouldLimitAddressSets(boolean b) {
        this.shouldLimitAddressSets = b;
    }

    public static enum AddressSetChoice {
        ENTIRE_PROGRAM,
        SELECTION,
        MANUALLY_DEFINED;

    }
}

