/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.AbstractStmt;
import ghidra.pcode.struct.ConditionalStmt;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;

class IfStmt
extends ConditionalStmt {
    protected AbstractStmt elseStmt;

    protected IfStmt(StructuredSleigh ctx, StructuredSleigh.RVal cond, StructuredSleigh.Stmt stmt) {
        super(ctx, cond, stmt);
    }

    @Override
    protected StringTree generate(StructuredSleigh.Label next, StructuredSleigh.Label fall) {
        StringTree st = new StringTree();
        if (this.elseStmt == null) {
            if (this.stmt.isSingleGoto()) {
                return this.stmt.getNext().genGoto(this.cond, fall);
            }
            StructuredSleigh.FreshLabel lTrue = new StructuredSleigh.FreshLabel(this.ctx);
            StructuredSleigh.Label lFalse = next.freshOrBorrow();
            StringTree condGen = lFalse.genGoto(this.cond.notb(), lTrue);
            StringTree stmtGen = this.stmt.generate(next, fall);
            st.append(condGen);
            st.append(lTrue.genAnchor());
            st.append(stmtGen);
            st.append(lFalse.genAnchor());
        } else {
            StructuredSleigh.FreshLabel lFalse = new StructuredSleigh.FreshLabel(this.ctx);
            StructuredSleigh.FreshLabel lTrue = new StructuredSleigh.FreshLabel(this.ctx);
            StructuredSleigh.Label lExit = next.freshOrBorrow();
            StringTree condGen = lTrue.genGoto(this.cond, lFalse);
            StringTree elseGen = this.elseStmt.generate(lExit, lTrue);
            StringTree stmtGen = this.stmt.generate(next, fall);
            st.append(condGen);
            st.append(lFalse.genAnchor());
            st.append(elseGen);
            st.append(lTrue.genAnchor());
            st.append(stmtGen);
            st.append(lExit.genAnchor());
        }
        return st;
    }

    protected void addElse(StructuredSleigh.Stmt elseStmt) {
        assert (this.elseStmt == null);
        this.elseStmt = ((AbstractStmt)elseStmt).reparent(this);
    }
}

