/*
 * Decompiled with CFR 0.152.
 */
package ghidra.taint.model;

import ghidra.taint.model.TaintMark;
import ghidra.taint.model.TaintSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaintVec {
    private TaintSet[] sets;
    private List<TaintSet> setsView;
    public final int length;

    public static TaintVec empties(int size) {
        return TaintVec.copies(TaintSet.EMPTY, size);
    }

    public static TaintVec copies(TaintSet taint, int size) {
        return new TaintVec(size).setCopies(taint);
    }

    public static TaintVec array(String name, long start, int size) {
        return new TaintVec(size).setArray(name, start);
    }

    public TaintVec(int length) {
        this.sets = new TaintSet[length];
        this.setsView = Collections.unmodifiableList(Arrays.asList(this.sets));
        this.length = this.sets.length;
    }

    public String toString() {
        return String.format("<TaintVec: %s>", this.toDisplay());
    }

    public String toDisplay() {
        return Stream.of(this.sets).map(e -> "[" + String.valueOf(e) + "]").collect(Collectors.joining());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaintVec)) {
            return false;
        }
        TaintVec that = (TaintVec)obj;
        return Objects.equals(this.setsView, that.setsView);
    }

    public int hashCode() {
        return Objects.hash(this.setsView);
    }

    public List<TaintSet> getSets() {
        return this.setsView;
    }

    public TaintSet get(int i) {
        return this.sets[i];
    }

    public void set(int i, TaintSet s) {
        this.sets[i] = s;
    }

    public TaintVec set(int start, TaintVec vec) {
        for (int i = 0; i < vec.length; ++i) {
            this.sets[i + start] = vec.sets[i];
        }
        return this;
    }

    private TaintVec zip(TaintVec that, BinaryOperator<TaintSet> op) {
        int length = this.sets.length;
        if (length != that.sets.length) {
            throw new IllegalArgumentException("TaintVecs must match in length");
        }
        TaintVec vec = new TaintVec(length);
        for (int i = 0; i < length; ++i) {
            vec.sets[i] = (TaintSet)op.apply(this.sets[i], that.sets[i]);
        }
        return vec;
    }

    private TaintVec each(TaintSet set, BinaryOperator<TaintSet> op) {
        int length = this.sets.length;
        TaintVec vec = new TaintVec(length);
        for (int i = 0; i < length; ++i) {
            vec.sets[i] = (TaintSet)op.apply(this.sets[i], set);
        }
        return vec;
    }

    public TaintVec zipUnion(TaintVec that) {
        return this.zip(that, TaintSet::union);
    }

    public TaintVec eachUnion(TaintSet set) {
        return this.each(set, TaintSet::union);
    }

    public TaintSet union() {
        HashSet<TaintMark> result = new HashSet<TaintMark>();
        for (int i = 0; i < this.sets.length; ++i) {
            result.addAll(this.sets[i].marks);
        }
        return TaintSet.of(result);
    }

    public TaintVec tagIndirectRead(TaintVec offset) {
        TaintSet taintOffset = offset.union().tagged("indR");
        return this.eachUnion(taintOffset);
    }

    public TaintVec tagIndirectWrite(TaintVec offset) {
        TaintSet taintOffset = offset.union().tagged("indW");
        return this.eachUnion(taintOffset);
    }

    public TaintVec setCopies(TaintSet taint) {
        for (int i = 0; i < this.length; ++i) {
            this.sets[i] = taint;
        }
        return this;
    }

    public TaintVec setEmpties() {
        return this.setCopies(TaintSet.EMPTY);
    }

    public TaintVec setArray(String name, long start) {
        for (int i = 0; i < this.length; ++i) {
            this.sets[i] = TaintSet.of(new TaintMark(name + "_" + (start + (long)i), Set.of()));
        }
        return this;
    }

    public TaintVec setCascade(boolean isBigEndian) {
        int i;
        if (isBigEndian) {
            for (i = this.length - 2; i >= 0; --i) {
                this.sets[i] = this.sets[i].union(this.sets[i + 1]);
            }
        }
        for (i = 0; i < this.length - 1; ++i) {
            this.sets[i + 1] = this.sets[i + 1].union(this.sets[i]);
        }
        return this;
    }

    public TaintVec setBlur(boolean right) {
        int i;
        if (right) {
            for (i = this.length - 2; i >= 0; --i) {
                this.sets[i + 1] = this.sets[i + 1].union(this.sets[i]);
            }
        }
        for (i = 0; i < this.length - 1; ++i) {
            this.sets[i] = this.sets[i].union(this.sets[i + 1]);
        }
        return this;
    }

    public TaintVec setShifted(int right, ShiftMode mode) {
        if ((right = mode.adjustRight(right, this.length)) > this.length || -right > this.length) {
            return this.setEmpties();
        }
        if (right < 0) {
            int src;
            TaintSet start = this.sets[0];
            for (int i = 0; i < this.length && (src = mode.adjustSrc(i - right, this.length)) >= 0 && src < this.length; ++i) {
                this.sets[i] = src == 0 ? start : this.sets[src];
            }
        } else {
            int src;
            TaintSet start = this.sets[this.length - 1];
            for (int i = 0; i < this.length - 1 && (src = mode.adjustSrc(i - right, this.length)) >= 0 && src < this.length; ++i) {
                this.sets[i] = src == this.length - 1 ? start : this.sets[src];
            }
        }
        return this;
    }

    public TaintVec truncated(int length, boolean isBigEndian) {
        if (length > this.length) {
            throw new IllegalArgumentException();
        }
        TaintVec vec = new TaintVec(length);
        int shift = isBigEndian ? this.length - length : 0;
        for (int i = 0; i < length; ++i) {
            vec.sets[i] = vec.sets[i + shift];
        }
        return vec;
    }

    public TaintVec copy() {
        TaintVec vec = new TaintVec(this.length);
        for (int i = 0; i < this.length; ++i) {
            vec.sets[i] = this.sets[i];
        }
        return vec;
    }

    public TaintVec extended(int length, boolean isBigEndian, boolean isSigned) {
        if (length < this.length) {
            return this.truncated(length, isBigEndian);
        }
        TaintVec vec = new TaintVec(length);
        int diff = length - this.length;
        int shift = isBigEndian ? diff : 0;
        for (int i = 0; i < this.length; ++i) {
            vec.sets[i + shift] = this.sets[i];
        }
        TaintSet ext = isSigned ? (isBigEndian ? this.sets[0] : this.sets[this.length - 1]) : TaintSet.EMPTY;
        int start = isBigEndian ? 0 : this.length;
        for (int i = 0; i < diff; ++i) {
            vec.sets[start + i] = ext;
        }
        return vec;
    }

    public static enum ShiftMode {
        UNBOUNDED{

            @Override
            int adjustRight(int right, int length) {
                return right;
            }

            @Override
            int adjustSrc(int src, int length) {
                return src;
            }
        }
        ,
        REMAINDER{

            @Override
            int adjustRight(int right, int length) {
                return right % length;
            }

            @Override
            int adjustSrc(int src, int length) {
                return src;
            }
        }
        ,
        CIRCULAR{

            @Override
            int adjustRight(int right, int length) {
                return right % length;
            }

            @Override
            int adjustSrc(int src, int length) {
                int temp = src % length;
                if (temp < 0) {
                    return temp + length;
                }
                return temp;
            }
        };


        abstract int adjustRight(int var1, int var2);

        abstract int adjustSrc(int var1, int var2);
    }
}

