/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import generic.theme.GIcon;
import ghidra.app.util.ColorAndStyle;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.SymbolInspector;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.LabelCodeUnitFormat;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.field.NamespacePropertyEditor;
import ghidra.app.util.viewer.field.NamespaceWrappedOption;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import resources.MultiIcon;
import resources.icons.EmptyIcon;

public class LabelFieldFactory
extends FieldFactory {
    private static final int MAX_OFFCUT_DISPLAY = 30;
    public static final String FIELD_NAME = "Label";
    public static final String OFFCUT_STYLE = "XRef Offcut Style";
    public static final String GROUP_TITLE = "Labels Field";
    public static final String DISPLAY_FUNCTION_LABEL = "Labels Field.Display Function Label";
    private static final String NAMESPACE_OPTIONS = "Labels Field.Display Namespace";
    private Icon EMPTY_ICON = new EmptyIcon(12, 16);
    private Icon ANCHOR_ICON = new MultiIcon(this.EMPTY_ICON, new Icon[]{new GIcon("icon.base.util.viewer.fieldfactory.label")});
    private boolean displayFunctionLabel;
    private boolean displayLocalNamespace;
    private boolean displayNonLocalNamespace;
    private SymbolInspector inspector;
    private boolean useLocalPrefixOverride;
    private String localPrefixText;
    protected BrowserCodeUnitFormat codeUnitFormat;
    private ChangeListener codeUnitFormatListener = e -> this.model.update();

    public LabelFieldFactory() {
        super(FIELD_NAME);
    }

    private LabelFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        super(FIELD_NAME, model, hlProvider, (Options)displayOptions, (Options)fieldOptions);
        this.inspector = new SymbolInspector(displayOptions, null);
        HelpLocation hl = new HelpLocation("CodeBrowserPlugin", "Labels_Field");
        fieldOptions.getOptions(GROUP_TITLE).setOptionsHelpLocation(hl);
        fieldOptions.registerOption(DISPLAY_FUNCTION_LABEL, (Object)true, hl, "Shows function names in a label field below the function header");
        this.displayFunctionLabel = fieldOptions.getBoolean(DISPLAY_FUNCTION_LABEL, true);
        this.setupNamespaceOptions((Options)fieldOptions);
        this.codeUnitFormat = new LabelCodeUnitFormat(fieldOptions);
        this.codeUnitFormat.addChangeListener(this.codeUnitFormatListener);
    }

    private void setupNamespaceOptions(Options fieldOptions) {
        fieldOptions.registerOption(NAMESPACE_OPTIONS, OptionType.CUSTOM_TYPE, (Object)new NamespaceWrappedOption(), null, "Adjusts the Label Field namespace display", () -> new NamespacePropertyEditor());
        CustomOption wrappedOption = fieldOptions.getCustomOption(NAMESPACE_OPTIONS, (CustomOption)new NamespaceWrappedOption());
        if (!(wrappedOption instanceof NamespaceWrappedOption)) {
            throw new AssertException("Someone set an option for Labels Field.Display Namespace that is not the expected ghidra.app.util.viewer.field.NamespaceWrappedOption type.");
        }
        NamespaceWrappedOption namespaceOption = (NamespaceWrappedOption)wrappedOption;
        this.displayLocalNamespace = namespaceOption.isShowLocalNamespace();
        this.displayNonLocalNamespace = namespaceOption.isShowNonLocalNamespace();
        this.useLocalPrefixOverride = namespaceOption.isUseLocalPrefixOverride();
        this.localPrefixText = namespaceOption.getLocalPrefixText();
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(DISPLAY_FUNCTION_LABEL)) {
            this.displayFunctionLabel = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(NAMESPACE_OPTIONS)) {
            this.setupNamespaceOptions(options);
            this.model.update();
        }
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        ExternalLocation extLoc;
        boolean hasOffcuts;
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        int x = this.startX + varWidth;
        CodeUnit cu = (CodeUnit)obj;
        Address currAddr = cu.getMinAddress();
        Program prog = cu.getProgram();
        Listing list = prog.getListing();
        Function func = list.getFunctionAt(currAddr);
        Symbol[] symbols = cu.getSymbols();
        List<Address> offcuts = this.getOffcutReferenceAddress(cu);
        boolean bl = hasOffcuts = offcuts.size() > 0;
        if (!hasOffcuts && symbols.length == 1 && func != null && !this.displayFunctionLabel) {
            return null;
        }
        this.makePrimaryLastItem(symbols);
        int length = symbols.length;
        if (!this.displayFunctionLabel && func != null) {
            length = symbols.length - 1;
        }
        if (hasOffcuts) {
            length += offcuts.size();
        }
        if (length == 0) {
            return null;
        }
        ArrayList<FieldElement> elements = new ArrayList<FieldElement>(length);
        if (hasOffcuts) {
            for (Address offcut : offcuts) {
                AttributedString as = this.getAttributedOffsetText(obj, cu, currAddr, offcut);
                if (as == null) {
                    as = new AttributedString(this.EMPTY_ICON, SymbolUtilities.getDynamicOffcutName((Address)currAddr), this.inspector.getOffcutSymbolColor(), this.getMetrics(this.inspector.getOffcutSymbolStyle()), false, null);
                }
                elements.add((FieldElement)new TextFieldElement(as, elements.size(), 0));
            }
        }
        if (currAddr.isExternalAddress() && length == 1 && (extLoc = prog.getExternalManager().getExternalLocation(symbols[0])) != null) {
            String origImportedName;
            StringBuilder externalLocationDetails = new StringBuilder();
            Address addr = extLoc.getAddress();
            if (addr != null) {
                externalLocationDetails.append(addr.toString());
            }
            if ((origImportedName = extLoc.getOriginalImportedName()) != null) {
                if (!externalLocationDetails.isEmpty()) {
                    externalLocationDetails.append(": ");
                }
                externalLocationDetails.append(origImportedName);
            }
            if (!externalLocationDetails.isEmpty()) {
                AttributedString as = new AttributedString(this.EMPTY_ICON, externalLocationDetails.toString(), OptionsGui.LABELS_NON_PRIMARY.getColor(), this.getMetrics(OptionsGui.LABELS_NON_PRIMARY.getStyle()), false, null);
                elements.add((FieldElement)new TextFieldElement(as, elements.size(), 0));
            }
        }
        for (Symbol symbol : symbols) {
            if (func != null && symbol.isPrimary() && !this.displayFunctionLabel) continue;
            Icon icon = symbol.isPinned() ? this.ANCHOR_ICON : this.EMPTY_ICON;
            ColorAndStyle c = this.inspector.getColorAndStyle(symbol);
            AttributedString as = new AttributedString(icon, this.checkLabelString(symbol, prog), c.getColor(), this.getMetrics(c.getStyle()), false, null);
            elements.add((FieldElement)new TextFieldElement(as, elements.size(), 0));
        }
        return ListingTextField.createMultilineTextField(this, proxy, elements, x, this.width, this.hlProvider);
    }

    private String getOffsetText(CodeUnit cu, Address currAddr, Address offcutAddress) {
        SymbolTable symbolTable = cu.getProgram().getSymbolTable();
        Symbol offcutSymbol = symbolTable.getPrimarySymbol(offcutAddress);
        if (offcutSymbol == null) {
            return SymbolUtilities.getDynamicOffcutName((Address)offcutAddress);
        }
        String offcutSymbolText = null;
        offcutSymbolText = !offcutSymbol.isDynamic() ? this.codeUnitFormat.getOffcutLabelString(offcutAddress, cu, null) : offcutSymbol.getName();
        return offcutSymbolText;
    }

    private AttributedString getAttributedOffsetText(Object obj, CodeUnit cu, Address currAddr, Address offcutAddress) {
        return new AttributedString(this.EMPTY_ICON, this.getOffsetText(cu, currAddr, offcutAddress), this.inspector.getOffcutSymbolColor(), this.getMetrics(this.inspector.getOffcutSymbolStyle()), false, null);
    }

    private String checkLabelString(Symbol symbol, Program program) {
        if (!this.displayLocalNamespace && !this.displayNonLocalNamespace) {
            return this.simplifyTemplates(symbol.getName());
        }
        Namespace addressNamespace = program.getSymbolTable().getNamespace(symbol.getAddress());
        Namespace symbolNamespace = symbol.getParentNamespace();
        boolean isLocal = symbolNamespace.equals((Object)addressNamespace);
        if (!isLocal) {
            return this.simplifyTemplates(symbol.getName(this.displayNonLocalNamespace));
        }
        if (!this.displayLocalNamespace) {
            return this.simplifyTemplates(symbol.getName());
        }
        if (this.useLocalPrefixOverride) {
            return this.simplifyTemplates(this.localPrefixText + symbol.getName(false));
        }
        return this.simplifyTemplates(symbol.getName(true));
    }

    private List<Address> getOffcutReferenceAddress(CodeUnit cu) {
        Symbol s;
        Address addr;
        Address addr2;
        Address startAddr = cu.getMinAddress();
        if (!startAddr.isMemoryAddress()) {
            return Collections.emptyList();
        }
        Program prog = cu.getProgram();
        if (cu.getLength() == 1) {
            return Collections.emptyList();
        }
        Address nextAddr = startAddr.next();
        if (nextAddr == null) {
            return Collections.emptyList();
        }
        Address endAddress = cu.getMaxAddress();
        ArrayList<Address> list = new ArrayList<Address>();
        AddressIterator it = prog.getReferenceManager().getReferenceDestinationIterator(nextAddr, true);
        while (it.hasNext() && (addr2 = it.next()).compareTo((Object)endAddress) <= 0) {
            if (addr2.compareTo((Object)cu.getMinAddress()) <= 0) continue;
            list.remove(addr2);
            list.add(addr2);
            if (list.size() <= 30) continue;
            return list;
        }
        SymbolIterator symIter = prog.getSymbolTable().getSymbolIterator(nextAddr, true);
        while (symIter.hasNext() && (addr = (s = symIter.next()).getAddress()).compareTo((Object)endAddress) <= 0) {
            if (addr.compareTo((Object)cu.getMinAddress()) <= 0) continue;
            list.remove(addr);
            list.add(addr);
            if (list.size() <= 30) continue;
            return list;
        }
        return list;
    }

    private void makePrimaryLastItem(Symbol[] symbols) {
        for (int i = 0; i < symbols.length - 1; ++i) {
            if (!symbols[i].isPrimary()) continue;
            Symbol primary = symbols[i];
            System.arraycopy(symbols, i + 1, symbols, i, symbols.length - i - 1);
            symbols[symbols.length - 1] = primary;
            break;
        }
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        List<Address> offcuts;
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        int[] cpath = null;
        if (cu instanceof Data) {
            cpath = ((Data)cu).getComponentPath();
        }
        if (row < (offcuts = this.getOffcutReferenceAddress(cu)).size()) {
            return this.getLocationForOffcuttLabel(row, col, cu, cpath, offcuts);
        }
        int symbolIndex = row - offcuts.size();
        Symbol s = this.getCodeOrFunctionSymbol(cu, symbolIndex);
        if (s == null) {
            return new CodeUnitLocation(cu.getProgram(), cu.getMinAddress(), cpath, 0, 0, 0);
        }
        return new LabelFieldLocation(s, row, col);
    }

    private Symbol getCodeOrFunctionSymbol(CodeUnit cu, int symbolIndex) {
        Symbol symbol;
        SymbolType symbolType;
        Symbol[] symbols = cu.getSymbols();
        if (symbols.length == 0) {
            return null;
        }
        this.makePrimaryLastItem(symbols);
        if (symbolIndex >= symbols.length) {
            symbolIndex = symbols.length - 1;
        }
        if ((symbolType = (symbol = symbols[symbolIndex]).getSymbolType()) != SymbolType.LABEL && symbolType != SymbolType.FUNCTION) {
            return null;
        }
        return symbol;
    }

    private ProgramLocation getLocationForOffcuttLabel(int row, int col, CodeUnit cu, int[] cpath, List<Address> offcuts) {
        Address addr = cu.getMinAddress();
        String text = this.getOffsetText(cu, addr, offcuts.get(row));
        if (text == null) {
            text = SymbolUtilities.getDynamicOffcutName((Address)addr);
        }
        return new LabelFieldLocation(cu.getProgram(), addr, cpath, text, null, row, col);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        Object obj = bf.getProxy().getObject();
        if (!(programLoc instanceof LabelFieldLocation)) {
            return null;
        }
        LabelFieldLocation loc = (LabelFieldLocation)programLoc;
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        String lableName = loc.getName();
        CodeUnit cu = (CodeUnit)obj;
        List<Address> offcuts = this.getOffcutReferenceAddress(cu);
        for (int i = 0; i < offcuts.size(); ++i) {
            String text = this.getOffsetText(cu, cu.getMinAddress(), offcuts.get(i));
            if (text == null || !text.equals(lableName)) continue;
            return new FieldLocation(index, fieldNum, i, loc.getCharOffset());
        }
        Symbol[] symbols = cu.getSymbols();
        this.makePrimaryLastItem(symbols);
        if (symbols.length == 0) {
            return null;
        }
        for (int i = 0; i < symbols.length; ++i) {
            if (!symbols[i].getName().equals(lableName)) continue;
            return new FieldLocation(index, fieldNum, i + offcuts.size(), loc.getCharOffset());
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions pDisplayOptions, ToolOptions fieldOptions) {
        return new LabelFieldFactory(formatModel, provider, pDisplayOptions, fieldOptions);
    }
}

