/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.types.TargetTypeContextDescriptor;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class TargetEnumDescriptor
extends TargetTypeContextDescriptor {
    private int numPayloadCasesAndPayloadSizeOffset;
    private int numEmptyCases;

    public TargetEnumDescriptor(BinaryReader reader) throws IOException {
        super(reader);
        this.numPayloadCasesAndPayloadSizeOffset = reader.readNextInt();
        this.numEmptyCases = reader.readNextInt();
    }

    public int getNumPayloadCasesAndPayloadSizeOffset() {
        return this.numPayloadCasesAndPayloadSizeOffset;
    }

    public int getNumEmptyCases() {
        return this.numEmptyCases;
    }

    @Override
    public String getStructureName() {
        return TargetEnumDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "enum descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getStructureName(), 0);
        struct.add(super.toDataType(), super.getStructureName(), "");
        struct.add(DWORD, "NumPayloadCasesAndPayloadSizeOffset", "The number of non-empty cases in the enum are in the low 24 bits; the offset of the payload size in the metadata record in words, if any, is stored in the high 8 bits.");
        struct.add(DWORD, "NumEmptyCases", "The number of empty cases in the enum");
        struct.setCategoryPath(new CategoryPath("/SwiftTypeMetadata"));
        return struct;
    }
}

