/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ProcedureIdEndMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.AbstractBlockContextApplier;
import ghidra.app.util.pdb.pdbapplicator.BlockNestingSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestableSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestingSymbolApplier;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class ProcedureIdEndSymbolApplier
extends MsSymbolApplier
implements BlockNestingSymbolApplier,
NestableSymbolApplier {
    private ProcedureIdEndMsSymbol symbol;

    public ProcedureIdEndSymbolApplier(DefaultPdbApplicator applicator, ProcedureIdEndMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    @Override
    public void applyTo(NestingSymbolApplier applyToApplier, MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        if (applyToApplier instanceof AbstractBlockContextApplier) {
            AbstractBlockContextApplier applier = (AbstractBlockContextApplier)applyToApplier;
            applier.endBlock();
        }
    }

    private ProcedureIdEndMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof ProcedureIdEndMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        ProcedureIdEndMsSymbol endSymbol = (ProcedureIdEndMsSymbol)abstractSymbol;
        return endSymbol;
    }
}

