/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tab;

import docking.widgets.list.GListCellRenderer;
import docking.widgets.searchlist.DefaultSearchListModel;
import docking.widgets.searchlist.SearchList;
import docking.widgets.searchlist.SearchListEntry;
import docking.widgets.searchlist.SearchListModel;
import docking.widgets.tab.GTabPanel;
import generic.util.WindowUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;

public class TabListPopup<T>
extends JDialog {
    private static final String HIDDEN = "Hidden";
    private static final String VISIBLE = "Visible";
    private GTabPanel<T> panel;
    private SearchList<T> searchList;

    TabListPopup(final GTabPanel<T> panel, JComponent positioningComponent, String typeName) {
        super(WindowUtilities.windowForComponent(panel));
        this.setTitle("Popup Window Showing All " + typeName + " Tabs");
        this.panel = panel;
        this.setUndecorated(true);
        this.getAccessibleContext().setAccessibleDescription("Use up down arrows to move between " + typeName + "tab choices and press enter to select tab. Type text to filter choices. Left right arrows to close popup and return focus to visible tabs");
        SearchListModel<T> tabListModel = this.createTabListModel();
        this.searchList = new SearchList<Object>(tabListModel, (T, C) -> panel.selectTab(T));
        this.searchList.setItemRenderer(new TabListRenderer());
        this.searchList.setShowCategories(false);
        this.searchList.setSingleClickMode(true);
        this.searchList.setMouseHoverSelection();
        this.searchList.setDisplayNameFunction((t, c) -> panel.getDisplayName(t));
        this.add(this.searchList);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                panel.tabListFocusLost();
            }
        });
        KeyAdapter keyListener = new KeyAdapter(this){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                switch (keyCode) {
                    case 37: {
                        panel.highlightFromTabList(false);
                        break;
                    }
                    case 39: {
                        panel.highlightFromTabList(true);
                    }
                }
            }
        };
        this.installKeyListener(this, keyListener);
        this.pack();
        this.positionRelativeTo(positioningComponent);
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }

    private SearchListModel<T> createTabListModel() {
        DefaultSearchListModel<T> model = new DefaultSearchListModel<T>();
        List<T> visibleValues = this.panel.getVisibleTabs();
        model.add(HIDDEN, this.panel.getHiddenTabs());
        model.add(VISIBLE, visibleValues);
        return model;
    }

    private void positionRelativeTo(JComponent component) {
        Rectangle bounds = this.getBounds();
        if (component == null) {
            Point centerPoint = WindowUtilities.centerOnComponent((Component)this.getParent(), (Component)this);
            bounds.setLocation(centerPoint);
            WindowUtilities.ensureEntirelyOnScreen((Component)this.getParent(), (Rectangle)bounds);
            this.setBounds(bounds);
            return;
        }
        Point p = component.getLocationOnScreen();
        int x = p.x;
        int y = p.y + component.getHeight() + 3;
        bounds.setLocation(x, y);
        WindowUtilities.ensureOnScreen((Component)component, (Rectangle)bounds);
        this.setBounds(bounds);
    }

    private void installKeyListener(Container c, KeyListener listener) {
        Component[] children;
        c.addKeyListener(listener);
        for (Component element : children = c.getComponents()) {
            if (element instanceof Container) {
                this.installKeyListener((Container)element, listener);
                continue;
            }
            element.addKeyListener(listener);
        }
    }

    private class TabListRenderer
    extends GListCellRenderer<SearchListEntry<T>> {
        public TabListRenderer() {
            this.setShouldAlternateRowBackgroundColors(false);
        }

        @Override
        protected String getItemText(SearchListEntry<T> value) {
            return TabListPopup.this.panel.getDisplayName(value.value());
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SearchListEntry<T>> list, SearchListEntry<T> value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, hasFocus);
            if (value.category().equals(TabListPopup.HIDDEN)) {
                this.setBold();
            }
            return this;
        }
    }
}

