/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.debug.api.action.GoToInput;
import ghidra.debug.api.action.LocationTracker;
import ghidra.debug.api.action.LocationTrackingSpec;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;

public interface RegisterLocationTrackingSpec
extends LocationTrackingSpec,
LocationTracker {
    public Register computeRegister(DebuggerCoordinates var1);

    public AddressSpace computeDefaultAddressSpace(DebuggerCoordinates var1);

    default public String computeTitle(DebuggerCoordinates coordinates) {
        Register register = this.computeRegister(coordinates);
        if (register == null) {
            return null;
        }
        return register.getName();
    }

    default public LocationTracker getTracker() {
        return this;
    }

    default public Address computeTraceAddress(ServiceProvider provider, DebuggerCoordinates coordinates) {
        TraceMemorySpace regs;
        Trace trace = coordinates.getTrace();
        TracePlatform platform = coordinates.getPlatform();
        TraceThread thread = coordinates.getThread();
        if (thread == null) {
            return null;
        }
        long viewSnap = coordinates.getViewSnap();
        long snap = coordinates.getSnap();
        int frame = coordinates.getFrame();
        Register reg = this.computeRegister(coordinates);
        if (reg == null) {
            return null;
        }
        if (!thread.isValid(snap)) {
            return null;
        }
        TraceMemorySpace traceMemorySpace = regs = reg.getAddressSpace().isRegisterSpace() ? trace.getMemoryManager().getMemoryRegisterSpace(thread, frame, false) : trace.getMemoryManager().getMemorySpace(reg.getAddressSpace(), false);
        if (regs == null) {
            return null;
        }
        RegisterValue value = regs.getState(platform, viewSnap, reg) == TraceMemoryState.KNOWN ? regs.getValue(platform, viewSnap, reg) : regs.getValue(platform, snap, reg);
        if (value == null) {
            return null;
        }
        return platform.mapGuestToHost(this.computeDefaultAddressSpace(coordinates).getAddress(value.getUnsignedValue().longValue(), true));
    }

    default public GoToInput getDefaultGoToInput(ServiceProvider provider, DebuggerCoordinates coordinates, ProgramLocation location) {
        Register register = this.computeRegister(coordinates);
        return GoToInput.offsetOnly((String)register.getName());
    }

    default public boolean affectedByBytesChange(TraceAddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates coordinates) {
        if (!LocationTrackingSpec.changeIsCurrent((TraceAddressSpace)space, (TraceAddressSnapRange)range, (DebuggerCoordinates)coordinates)) {
            return false;
        }
        Register register = this.computeRegister(coordinates);
        AddressSpace as = space.getAddressSpace();
        if (register == null || register.getAddressSpace() != as) {
            return false;
        }
        AddressRange regRng = coordinates.getPlatform().getConventionalRegisterRange((AddressSpace)(as.isRegisterSpace() ? as : null), register);
        return range.getRange().intersects(regRng);
    }

    default public boolean affectedByStackChange(TraceStack stack, DebuggerCoordinates coordinates) {
        return false;
    }
}

