/*
 * Decompiled with CFR 0.152.
 */
package help.validator;

import help.HelpBuildUtils;
import help.validator.AnchorManager;
import help.validator.TagProcessor;
import help.validator.location.HelpModuleLocation;
import help.validator.model.HREF;
import help.validator.model.IMG;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class ReferenceTagProcessor
extends TagProcessor {
    private static final String EOL = System.getProperty("line.separator");
    private static final String SHARED_STYLESHEET_NAME = "help/shared/DefaultStyle.css";
    private static final Path SHARED_STYLESHEET_PATH = Paths.get("help/shared/DefaultStyle.css", new String[0]);
    private Path htmlFile;
    private Set<Path> styleSheets = new HashSet<Path>();
    private String title;
    private boolean readingTitle = false;
    private final StringBuffer errors = new StringBuffer();
    private final AnchorManager anchorManager;
    private final HelpModuleLocation help;
    private int errorCount;

    public ReferenceTagProcessor(HelpModuleLocation help, AnchorManager anchorManager) {
        this.help = help;
        this.anchorManager = anchorManager;
    }

    @Override
    public boolean isTagSupported(String tagType) {
        if (tagType == null) {
            return false;
        }
        return "a".equals(tagType = tagType.toLowerCase()) || "img".equals(tagType) || "title".equals(tagType) || "/title".equals(tagType) || "link".equals(tagType);
    }

    @Override
    public void processTag(String tagType, LinkedHashMap<String, String> tagAttributes, Path file, int lineNum) throws IOException {
        if ("a".equals(tagType = tagType.toLowerCase())) {
            if (tagAttributes.containsKey("href")) {
                try {
                    this.anchorManager.addAnchorRef(new HREF(this.help, file, tagAttributes.get("href"), lineNum));
                }
                catch (URISyntaxException e) {
                    ++this.errorCount;
                    this.errors.append("Malformed Anchor Tag at (line " + lineNum + "): " + String.valueOf(this.htmlFile) + EOL);
                }
            } else if (tagAttributes.containsKey("name")) {
                this.anchorManager.addAnchor(file, tagAttributes.get("name"), lineNum);
            } else {
                ++this.errorCount;
                this.errors.append("Bad Anchor Tag - unexpected attribtute (line " + lineNum + "): " + String.valueOf(this.htmlFile) + EOL);
            }
        } else if ("img".equals(tagType)) {
            if (tagAttributes.containsKey("src")) {
                try {
                    this.anchorManager.addImageRef(new IMG(this.help, file, tagAttributes.get("src"), lineNum));
                }
                catch (URISyntaxException e) {
                    ++this.errorCount;
                    this.errors.append("Malformed IMG Tag at (line " + lineNum + "): " + String.valueOf(this.htmlFile) + EOL);
                }
            } else {
                ++this.errorCount;
                this.errors.append("Bad IMG Tag - unexpected attribtute (line " + lineNum + "): " + String.valueOf(this.htmlFile) + EOL);
            }
        } else if ("link".equals(tagType)) {
            String href;
            String rel = tagAttributes.get("rel");
            if (rel != null && "stylesheet".equals(rel.toLowerCase()) && (href = tagAttributes.get("href")) != null) {
                if (SHARED_STYLESHEET_NAME.equals(href)) {
                    this.styleSheets.add(SHARED_STYLESHEET_PATH);
                } else {
                    Path css = HelpBuildUtils.getFile(this.htmlFile, href);
                    css = css.normalize();
                    this.styleSheets.add(css);
                }
            }
        } else if ("title".equals(tagType)) {
            this.readingTitle = true;
        } else if ("/title".equals(tagType)) {
            this.readingTitle = false;
        }
    }

    @Override
    public String processText(String text) {
        if (this.readingTitle && (text = text.trim()).length() != 0) {
            this.title = this.title == null ? text : this.title + " " + text;
        }
        return text;
    }

    @Override
    public void startOfFile(Path localFile) {
        this.htmlFile = localFile;
        this.title = null;
        this.styleSheets.clear();
    }

    @Override
    public void endOfFile() {
        if (this.title == null) {
            ++this.errorCount;
            this.errors.append("Missing TITLE in: " + String.valueOf(this.htmlFile) + EOL);
        }
        if (this.styleSheets.isEmpty()) {
            ++this.errorCount;
            this.errors.append("Missing Stylesheet in: " + String.valueOf(this.htmlFile) + EOL);
        }
        boolean hasDefaultStyleSheet = false;
        for (Path ss : this.styleSheets) {
            if (!SHARED_STYLESHEET_PATH.equals(ss)) continue;
            hasDefaultStyleSheet = true;
            break;
        }
        if (!hasDefaultStyleSheet) {
            ++this.errorCount;
            this.errors.append("Incorrect stylesheet defined - none match help/shared/DefaultStyle.css in file " + String.valueOf(this.htmlFile) + EOL + "\tDiscovered stylesheets: " + String.valueOf(this.styleSheets) + EOL);
        }
    }

    public String getErrorText() {
        return this.errors.toString();
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }
}

