/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.MergeSortingSpliterator;
import ghidra.util.database.DBSynchronizedSpliterator;
import ghidra.util.database.SynchronizedSpliterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.locks.Lock;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtils {
    private StreamUtils() {
    }

    public static <T> Stream<T> merge(Collection<? extends Stream<? extends T>> streams, Comparator<? super T> comparator) {
        if (streams.size() == 1) {
            return streams.iterator().next();
        }
        return StreamSupport.stream(new MergeSortingSpliterator<T>(streams.stream().map(s -> s.spliterator()).toList(), comparator), false);
    }

    public static <T> Iterable<T> iter(Stream<? extends T> stream) {
        return () -> stream.iterator();
    }

    public static <T> Stream<T> sync(Object lock, Stream<T> stream) {
        SynchronizedSpliterator wrapped = new SynchronizedSpliterator(stream.spliterator(), lock);
        return StreamSupport.stream(wrapped, stream.isParallel());
    }

    public static <T> Stream<T> lock(Lock lock, Stream<T> stream) {
        DBSynchronizedSpliterator wrapped = new DBSynchronizedSpliterator(stream.spliterator(), lock);
        return StreamSupport.stream(wrapped, stream.isParallel());
    }
}

