/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.annotproc;

import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annotproc.AbstractDBAnnotationValidator;
import ghidra.util.database.annotproc.ValidationContext;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

public class DBAnnotatedColumnValidator
extends AbstractDBAnnotationValidator {
    final VariableElement column;

    public DBAnnotatedColumnValidator(ValidationContext ctx, VariableElement column) {
        super(ctx);
        this.column = column;
    }

    public void validate() {
        Set<Modifier> mods;
        if (!this.ctx.hasType(this.column, this.ctx.DB_OBJECT_COLUMN_ELEM)) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s can only be applied to fields of type %s", DBAnnotatedColumn.class.getSimpleName(), this.ctx.DB_OBJECT_COLUMN_ELEM), this.column);
        }
        if ((mods = this.column.getModifiers()).contains((Object)Modifier.FINAL)) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s cannot be applied to a final field", DBAnnotatedColumn.class.getSimpleName()), this.column);
        }
        if (!mods.contains((Object)Modifier.STATIC)) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s must be applied to a static field", DBAnnotatedColumn.class.getSimpleName()), this.column);
        }
        TypeElement type = (TypeElement)this.column.getEnclosingElement();
        this.checkEnclosingType(DBAnnotatedColumn.class, this.column, type);
    }
}

