/*
 * Decompiled with CFR 0.152.
 */
package ghidra.closedpatternmining;

import ghidra.closedpatternmining.FrequentSequenceItem;
import ghidra.closedpatternmining.Sequence;
import ghidra.closedpatternmining.SequenceItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class SequenceDatabase {
    private int sequenceLength;
    private List<Sequence> sequences;
    private int totalNumSeqs;

    public SequenceDatabase(List<Sequence> sequencesToMine, int sequenceLength) {
        if (sequenceLength < 1) {
            throw new IllegalArgumentException("length must be positive!");
        }
        this.sequenceLength = sequenceLength;
        this.sequences = sequencesToMine;
        this.totalNumSeqs = 0;
        for (Sequence seq : this.sequences) {
            if (seq.getSequenceAsString().length() != sequenceLength) {
                throw new IllegalArgumentException("sequence " + seq.getSequenceAsString() + " does not have length " + sequenceLength);
            }
            this.totalNumSeqs += seq.getCount();
        }
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public int getTotalNumSeqs() {
        return this.totalNumSeqs;
    }

    public TreeSet<FrequentSequenceItem> getGloballyFrequentItems(int minSupport) {
        HashMap<SequenceItem, Integer> itemBag = new HashMap<SequenceItem, Integer>();
        TreeSet<FrequentSequenceItem> frequentItemSet = new TreeSet<FrequentSequenceItem>();
        for (Sequence sequence : this.sequences) {
            for (int i = 0; i < this.sequenceLength; ++i) {
                SequenceItem fItem = new SequenceItem(sequence.getSequenceAsString().substring(i, i + 1), i);
                Integer count = (Integer)itemBag.get(fItem);
                if (count == null) {
                    itemBag.put(fItem, sequence.getCount());
                    continue;
                }
                itemBag.put(fItem, count + sequence.getCount());
            }
        }
        for (Map.Entry entry : itemBag.entrySet()) {
            int count = (Integer)entry.getValue();
            if (count < minSupport) continue;
            frequentItemSet.add(new FrequentSequenceItem(count, (SequenceItem)entry.getKey()));
        }
        return frequentItemSet;
    }
}

