/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.gui.filters.BSimValueEditor;
import ghidra.features.bsim.gui.filters.BooleanBSimValueEditor;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.client.SQLEffects;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.elastic.ElasticEffects;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.features.bsim.query.elastic.IDElasticResolution;
import ghidra.features.bsim.query.facade.SimilarFunctionQueryService;
import ghidra.features.bsim.query.protocol.FilterAtom;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import utility.function.Callback;

public class FunctionTagBSimFilterType
extends BSimFilterType {
    public static final String XML_VALUE = "functiontag";
    public static int RESERVED_BITS = 3;
    public static int MAX_TAG_COUNT = 32 - RESERVED_BITS;
    public static int KNOWN_LIBRARY_MASK = 1;
    public static int HAS_UNIMPLEMENTED_MASK = 2;
    public static int HAS_BADDATA_MASK = 4;
    private String tagName;
    private int flag;

    public FunctionTagBSimFilterType(String tagName, int flag) {
        super("Function tagged as " + tagName, XML_VALUE, "function tag");
        this.tagName = tagName;
        this.flag = flag;
    }

    public FunctionTagBSimFilterType(String tagName, SimilarFunctionQueryService queryService) throws InvalidInputException {
        super("Function tagged as " + tagName, XML_VALUE, "function tag");
        this.tagName = tagName;
        DatabaseInformation info = queryService.getDatabaseInformation();
        if (info == null) {
            throw new IllegalStateException("queryService has not been initialized");
        }
        List<String> functionTags = info.functionTags;
        if (functionTags == null) {
            throw new InvalidInputException("Function tag does not exist: " + tagName);
        }
        this.flag = 8;
        for (String tag : functionTags) {
            if (tag.endsWith(tagName)) break;
            this.flag *= 2;
        }
    }

    public int getFlag() {
        return this.flag;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.flag, this.tagName);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof FunctionTagBSimFilterType) {
            FunctionTagBSimFilterType t = (FunctionTagBSimFilterType)obj;
            return this.flag == t.flag && Objects.equals(this.tagName, t.tagName);
        }
        return false;
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        super.saveXml(fwrite);
        fwrite.append(" tagname=\"").append(this.tagName).append('\"');
        fwrite.append(" flag=\"").append(Integer.toString(this.flag)).append('\"');
    }

    @Override
    public IDSQLResolution generateIDSQLResolution(FilterAtom atom) {
        return null;
    }

    @Override
    public boolean evaluate(ExecutableRecord rec, String value) {
        return true;
    }

    @Override
    public boolean isMultipleEntryAllowed() {
        return false;
    }

    @Override
    public void gatherSQLEffect(SQLEffects effect, FilterAtom atom, IDSQLResolution resolution) throws SQLException {
        effect.addFunctionFilter(this.flag, atom.value.equals("true"));
    }

    @Override
    public void gatherElasticEffect(ElasticEffects effect, FilterAtom atom, IDElasticResolution resolution) throws ElasticException {
        effect.addFunctionFilter(this.flag, atom.value.equals("true"));
    }

    @Override
    public String normalizeValue(String value) {
        if (value != null) {
            if (value.equals("f") || value.equals("false")) {
                return "false";
            }
            if (value.equals("t") || value.equals("true")) {
                return "true";
            }
        }
        return null;
    }

    @Override
    public boolean isValidValue(String value) {
        return this.normalizeValue(value) != null;
    }

    @Override
    public BSimValueEditor getEditor(List<String> initialValues, Callback listener) {
        return new BooleanBSimValueEditor(this, initialValues, listener);
    }
}

