/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfscommon;

import org.catacombae.hfsexplorer.types.hfscommon.CommonBTNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfsexplorer.types.hfsplus.BTHeaderRec;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonHFSCatalogLeafNode
extends CommonBTNode<CommonHFSCatalogLeafRecord> {
    protected CommonHFSCatalogLeafNode(byte[] data, int offset, int nodeSize, CommonBTNode.FSType type) {
        super(data, offset, nodeSize, type);
    }

    public CommonHFSCatalogLeafRecord[] getLeafRecords() {
        return this.ic.records.toArray(new CommonHFSCatalogLeafRecord[this.ic.records.size()]);
    }

    public static CommonHFSCatalogLeafNode createHFSPlus(byte[] data, int offset, int nodeSize) {
        return new HFSPlusImplementation(data, offset, nodeSize);
    }

    public static CommonHFSCatalogLeafNode createHFSX(byte[] data, int offset, int nodeSize, BTHeaderRec bthr) {
        return new HFSXImplementation(data, offset, nodeSize, bthr).getInternal();
    }

    public static CommonHFSCatalogLeafNode createHFS(byte[] data, int offset, int nodeSize) {
        return new HFSImplementation(data, offset, nodeSize);
    }

    public static class HFSImplementation
    extends CommonHFSCatalogLeafNode {
        public HFSImplementation(byte[] data, int offset, int nodeSize) {
            super(data, offset, nodeSize, CommonBTNode.FSType.HFS);
        }

        protected CommonHFSCatalogLeafRecord createBTRecord(int recordNumber, byte[] data, int offset, int length) {
            return CommonHFSCatalogLeafRecord.createHFS(data, offset, length);
        }
    }

    public static class HFSXImplementation {
        private final BTHeaderRec bthr;
        private final Internal internal;

        public HFSXImplementation(byte[] data, int offset, int nodeSize, BTHeaderRec bthr) {
            this.bthr = bthr;
            this.internal = new Internal(data, offset, nodeSize);
        }

        private Internal getInternal() {
            return this.internal;
        }

        private class Internal
        extends CommonHFSCatalogLeafNode {
            public Internal(byte[] data, int offset, int nodeSize) {
                super(data, offset, nodeSize, CommonBTNode.FSType.HFS_PLUS);
                if (HFSXImplementation.this.bthr == null) {
                    throw new IllegalArgumentException("bthr == null");
                }
            }

            protected CommonHFSCatalogLeafRecord createBTRecord(int recordNumber, byte[] data, int offset, int length) {
                if (HFSXImplementation.this.bthr == null) {
                    throw new IllegalArgumentException("bthr == null");
                }
                return CommonHFSCatalogLeafRecord.createHFSX(data, offset, length, HFSXImplementation.this.bthr);
            }
        }
    }

    private static class HFSPlusImplementation
    extends CommonHFSCatalogLeafNode {
        public HFSPlusImplementation(byte[] data, int offset, int nodeSize) {
            super(data, offset, nodeSize, CommonBTNode.FSType.HFS_PLUS);
        }

        protected HFSPlusCatalogKey createKey(byte[] data, int offset, int length) {
            return new HFSPlusCatalogKey(data, offset);
        }

        protected CommonHFSCatalogLeafRecord createBTRecord(int recordNumber, byte[] data, int offset, int length) {
            return CommonHFSCatalogLeafRecord.createHFSPlus(data, offset, length);
        }
    }
}

