/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sevenzipjbinding.simple.impl;

import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import net.sf.sevenzipjbinding.simple.impl.SimpleInArchiveItemImpl;

public class SimpleInArchiveImpl
implements ISimpleInArchive {
    private final IInArchive sevenZipInArchive;
    private boolean wasClosed = false;

    public SimpleInArchiveImpl(IInArchive iInArchive) {
        this.sevenZipInArchive = iInArchive;
    }

    public void close() throws SevenZipException {
        this.sevenZipInArchive.close();
        this.wasClosed = true;
    }

    public ISimpleInArchiveItem[] getArchiveItems() throws SevenZipException {
        ISimpleInArchiveItem[] iSimpleInArchiveItemArray = new ISimpleInArchiveItem[this.getNumberOfItems()];
        for (int i = 0; i < iSimpleInArchiveItemArray.length; ++i) {
            iSimpleInArchiveItemArray[i] = new SimpleInArchiveItemImpl(this, i);
        }
        return iSimpleInArchiveItemArray;
    }

    public int getNumberOfItems() throws SevenZipException {
        return this.testAndGetSafeSevenZipInArchive().getNumberOfItems();
    }

    public IInArchive testAndGetSafeSevenZipInArchive() throws SevenZipException {
        if (this.wasClosed) {
            throw new SevenZipException("Archive was closed");
        }
        return this.sevenZipInArchive;
    }

    public ISimpleInArchiveItem getArchiveItem(int n) throws SevenZipException {
        if (n < 0 || n >= this.sevenZipInArchive.getNumberOfItems()) {
            throw new SevenZipException("Index " + n + " is out of range. Number of items in archive: " + this.sevenZipInArchive.getNumberOfItems());
        }
        return new SimpleInArchiveItemImpl(this, n);
    }
}

