# -*- coding: binary -*-

module Msf

###
#
# This module exposes methods for querying a remote DNS service
#
###
module Exploit::Remote::DNS
module Server
  include Exploit::Remote::DNS::Common
  include Exploit::Remote::SocketServer

  #
  # Initializes an exploit module that serves DNS requests
  #
  def initialize(info = {})
    super

    register_options(
      [
        OptPort.new('SRVPORT', [true, 'The local port to listen on.', 53]),
        OptString.new('STATIC_ENTRIES', [ false, "DNS domain search list (hosts file or space/semicolon separate entries)"]),
        OptBool.new('DISABLE_RESOLVER', [ false, "Disable DNS request forwarding", false]),
        OptBool.new('DISABLE_NS_CACHE', [ false, "Disable DNS response caching", false])
      ], Exploit::Remote::DNS::Server
    )

    register_advanced_options(
      [
        OptBool.new('DnsServerUdp', [true, "Serve UDP DNS requests", true]),
        OptBool.new('DnsServerTcp', [true, "Serve TCP DNS requests", false])
      ], Exploit::Remote::DNS::Server
    )
  end

  attr_accessor :service # :nodoc:

  #
  # Process static entries
  #
  # @param entries [String] Filename or String containing static entries
  # @param type [String] Type of record for which to add static entries
  #
  # @return [Array] List of static entries in the cache
  def add_static_hosts(entries = datastore['STATIC_ENTRIES'], type = 'A')
    return if entries.nil? or entries.empty?
    if File.file?(File.expand_path(entries))
      data = File.read(File.expand_path(entries)).split("\n")
    else
      data = entries.split(';')
    end
    data.each do |entry|
      next if entry.gsub(/\s/, '').empty?

      address, names = entry.split(' ', 2)
      names.split.each do |name|
        name << '.' unless name.end_with?('.') || name == '*'

        unless Rex::Socket.is_ip_addr?(address.to_s) && (name.to_s.match(MATCH_HOSTNAME) || name == '*')
          raise "Invalid parameters for static entry - #{name}, #{address}, #{type}"
        end

        service.cache.cache_record(Dnsruby::RR.create(name: name, type: type, address: address), expire: false)
      end
    end
    service.cache.records.select {|r,e| e == 0}
  end

  #
  # Flush all static entries
  #
  def flush_static_hosts
    data.cache.records.select {|r,e| e == 0}.each do |flush|
      data.cache.delete(flush)
    end
  end

  #
  # Flush cache entries
  # @param static [TrueClass, FalseClass] flush static hosts
  def flush_cache(static = false)
    self.service.cache.stop(true)
    flush_static_hosts if static
    self.service.cache.start
  end

  #
  # Handle incoming requests
  # Override this method in modules to take flow control
  #
  def on_dispatch_request(cli, data)
    service.default_dispatch_request(cli,data)
  end

  #
  # Handle incoming requests
  # Override this method in modules to take flow control
  #
  def on_send_response(cli, data)
    cli.write(data)
  end

  #
  # Starts the server
  #
  def start_service
    begin

      comm = _determine_server_comm(bindhost)
      self.service = Rex::ServiceManager.start(
        Rex::Proto::DNS::Server,
        bindhost,
        bindport,
        datastore['DnsServerUdp'],
        datastore['DnsServerTcp'],
        !datastore['DISABLE_NS_CACHE'],
        (use_resolver? ? setup_resolver : false),
        comm,
        {'Msf' => framework, 'MsfExploit' => self}
      )

      self.service.dispatch_request_proc = Proc.new do |cli, data|
        on_dispatch_request(cli,data)
      end
      self.service.send_response_proc = Proc.new do |cli, data|
        on_send_response(cli,data)
      end

      add_static_hosts

    rescue ::Errno::EACCES => e
      raise Rex::BindFailed.new(e.message)
    end
  end

  #
  # Dereference the DNS service
  #
  def cleanup
    super
    @dns_resolver = nil if @dns_resolver
  end

  #
  # Determines if resolver is available and configured for use
  #
  def use_resolver?
    !datastore['DISABLE_RESOLVER'] and self.respond_to?(:setup_resolver)
  end

end
end
end
