/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.nut;

import java.util.EnumSet;
import java.util.Set;

public class FrameCode {
    public final Set<Flag> flags;
    public final int streamId;
    public final int dataSizeMul;
    public final int dataSizeLsb;
    public final long ptsDelta;
    public final long reservedCount;
    public final long matchTimeDelta;
    public final long elisionHeaderIdx;
    public static final FrameCode INVALID = new FrameCode(EnumSet.of(Flag.INVALID), 0, 0, 0, 0L, 0L, 0L, 0L);

    public FrameCode(Set<Flag> flags, int streamId, int dataSizeMul, int dataSizeLsb, long ptsDelta, long reservedCount, long matchTimeDelta, long elisionHeaderIdx) {
        this.flags = flags;
        this.streamId = streamId;
        this.dataSizeMul = dataSizeMul;
        this.dataSizeLsb = dataSizeLsb;
        this.ptsDelta = ptsDelta;
        this.reservedCount = reservedCount;
        this.matchTimeDelta = matchTimeDelta;
        this.elisionHeaderIdx = elisionHeaderIdx;
    }

    public String toString() {
        return "FrameCode{flags=" + this.flags + ", streamId=" + this.streamId + ", dataSizeMul=" + this.dataSizeMul + ", dataSizeLsb=" + this.dataSizeLsb + ", ptsDelta=" + this.ptsDelta + ", reservedCount=" + this.reservedCount + ", matchTimeDelta=" + this.matchTimeDelta + ", headerIdx=" + this.elisionHeaderIdx + '}';
    }

    public static enum Flag {
        KEYFRAME(1L),
        EOR(2L),
        CODED_PTS(8L),
        STREAM_ID(16L),
        SIZE_MSB(32L),
        CHECKSUM(64L),
        RESERVED(128L),
        SM_DATA(256L),
        HEADER_IDX(1024L),
        MATCH_TIME(2048L),
        CODED_FLAGS(4096L),
        INVALID(8192L);

        private final long code;

        private Flag(long code) {
            this.code = code;
        }

        public static Set<Flag> fromBitCode(long value) {
            EnumSet<Flag> result = EnumSet.noneOf(Flag.class);
            for (Flag flag : Flag.values()) {
                if ((flag.code & value) <= 0L) continue;
                result.add(flag);
            }
            return result;
        }

        public static long toBitCode(Set<Flag> flags) {
            long result = 0L;
            for (Flag flag : flags) {
                result += flag.code;
            }
            return result;
        }

        public static Set<Flag> xor(Set<Flag> op1, Set<Flag> op2) {
            EnumSet<Flag> result = EnumSet.copyOf(op1);
            for (Flag codedFlag : op2) {
                if (result.contains((Object)codedFlag)) {
                    result.remove((Object)codedFlag);
                    continue;
                }
                result.add(codedFlag);
            }
            return result;
        }
    }
}

