/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.regex;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.regex.RegexPolicyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.RegexPolicyRepresentation;

public class RegexPolicyProviderFactory
implements PolicyProviderFactory<RegexPolicyRepresentation> {
    private RegexPolicyProvider provider = new RegexPolicyProvider(this::toRepresentation);

    public PolicyProvider create(KeycloakSession session) {
        return this.provider;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "regex";
    }

    public String getName() {
        return "Regex";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public RegexPolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        RegexPolicyRepresentation representation = new RegexPolicyRepresentation();
        Map config = policy.getConfig();
        representation.setTargetClaim((String)config.get("targetClaim"));
        representation.setPattern((String)config.get("pattern"));
        representation.setTargetContextAttributes(Boolean.parseBoolean((String)config.get("targetContextAttributes")));
        return representation;
    }

    public Class<RegexPolicyRepresentation> getRepresentationType() {
        return RegexPolicyRepresentation.class;
    }

    public void onCreate(Policy policy, RegexPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updatePolicy(policy, representation);
    }

    public void onUpdate(Policy policy, RegexPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updatePolicy(policy, representation);
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        policy.setConfig(representation.getConfig());
    }

    private void updatePolicy(Policy policy, RegexPolicyRepresentation representation) {
        HashMap<String, String> config = new HashMap<String, String>(policy.getConfig());
        config.put("targetClaim", representation.getTargetClaim());
        config.put("pattern", representation.getPattern());
        config.put("targetContextAttributes", String.valueOf(representation.isTargetContextAttributes()));
        policy.setConfig(config);
    }
}

