/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.index.IndexWrapper;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.index.PersistentClassIndex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class CombinedIndexBuildStep {
    @BuildStep
    CombinedIndexBuildItem build(ApplicationArchivesBuildItem archives, List<AdditionalIndexedClassesBuildItem> additionalIndexedClassesItems, LiveReloadBuildItem liveReloadBuildItem) {
        ArrayList<IndexView> archiveIndexes = new ArrayList<IndexView>();
        for (ApplicationArchive i : archives.getAllApplicationArchives()) {
            archiveIndexes.add(i.getIndex());
        }
        CompositeIndex archivesIndex = CompositeIndex.create(archiveIndexes);
        Indexer indexer = new Indexer();
        HashSet<DotName> additionalIndex = new HashSet<DotName>();
        HashSet<DotName> knownMissingClasses = new HashSet<DotName>();
        for (AdditionalIndexedClassesBuildItem additionalIndexedClasses : additionalIndexedClassesItems) {
            for (String classToIndex : additionalIndexedClasses.getClassesToIndex()) {
                IndexingUtil.indexClass(classToIndex, indexer, (IndexView)archivesIndex, additionalIndex, knownMissingClasses, Thread.currentThread().getContextClassLoader());
            }
        }
        PersistentClassIndex index = liveReloadBuildItem.getContextObject(PersistentClassIndex.class);
        if (index == null) {
            index = new PersistentClassIndex();
            liveReloadBuildItem.setContextObject(PersistentClassIndex.class, index);
        }
        Map<DotName, Optional<ClassInfo>> additionalClasses = index.getAdditionalClasses();
        for (DotName knownMissingClass : knownMissingClasses) {
            additionalClasses.put(knownMissingClass, Optional.empty());
        }
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{archivesIndex, indexer.complete()});
        RuntimeUpdatesProcessor.setLastStartIndex((IndexView)compositeIndex);
        return new CombinedIndexBuildItem((IndexView)compositeIndex, new IndexWrapper((IndexView)compositeIndex, Thread.currentThread().getContextClassLoader(), index));
    }
}

