/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.recording.substitutions;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ObjectSubstitutionBuildItem;
import io.quarkus.runtime.recording.substitutions.ZoneIdSubstitution;

public class AdditionalSubstitutionsBuildStep {
    @BuildStep
    public void additionalSubstitutions(BuildProducer<ObjectSubstitutionBuildItem> producer) {
        this.zoneIdSubstitutions(producer);
    }

    private void zoneIdSubstitutions(BuildProducer<ObjectSubstitutionBuildItem> producer) {
        try {
            Class<?> zoneRegionClass = Class.forName("java.time.ZoneRegion");
            producer.produce(new ObjectSubstitutionBuildItem(zoneRegionClass, String.class, ZoneIdSubstitution.class));
            Class<?> zoneOffsetClass = Class.forName("java.time.ZoneOffset");
            producer.produce(new ObjectSubstitutionBuildItem(zoneOffsetClass, String.class, ZoneIdSubstitution.class));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Improper registration of ZoneId substitution", e);
        }
    }
}

