/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.CodeElement;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.components.CodeRelabeler;
import io.github.dmlloyd.classfile.instruction.BranchInstruction;
import io.github.dmlloyd.classfile.instruction.CharacterRange;
import io.github.dmlloyd.classfile.instruction.ExceptionCatch;
import io.github.dmlloyd.classfile.instruction.LabelTarget;
import io.github.dmlloyd.classfile.instruction.LocalVariable;
import io.github.dmlloyd.classfile.instruction.LocalVariableType;
import io.github.dmlloyd.classfile.instruction.LookupSwitchInstruction;
import io.github.dmlloyd.classfile.instruction.SwitchCase;
import io.github.dmlloyd.classfile.instruction.TableSwitchInstruction;
import java.util.function.BiFunction;

public record CodeRelabelerImpl(BiFunction<Label, CodeBuilder, Label> mapFunction) implements CodeRelabeler
{
    public Label relabel(Label label, CodeBuilder cob) {
        return this.mapFunction.apply(label, cob);
    }

    @Override
    public void accept(CodeBuilder cob, CodeElement coe) {
        if (coe instanceof BranchInstruction) {
            BranchInstruction bi = (BranchInstruction)coe;
            cob.branch(bi.opcode(), this.relabel(bi.target(), cob));
        } else if (coe instanceof LookupSwitchInstruction) {
            LookupSwitchInstruction lsi = (LookupSwitchInstruction)coe;
            cob.lookupswitch(this.relabel(lsi.defaultTarget(), cob), lsi.cases().stream().map(c -> SwitchCase.of(c.caseValue(), this.relabel(c.target(), cob))).toList());
        } else if (coe instanceof TableSwitchInstruction) {
            TableSwitchInstruction tsi = (TableSwitchInstruction)coe;
            cob.tableswitch(tsi.lowValue(), tsi.highValue(), this.relabel(tsi.defaultTarget(), cob), tsi.cases().stream().map(c -> SwitchCase.of(c.caseValue(), this.relabel(c.target(), cob))).toList());
        } else if (coe instanceof LabelTarget) {
            LabelTarget lt = (LabelTarget)coe;
            cob.labelBinding(this.relabel(lt.label(), cob));
        } else if (coe instanceof ExceptionCatch) {
            ExceptionCatch ec = (ExceptionCatch)coe;
            cob.exceptionCatch(this.relabel(ec.tryStart(), cob), this.relabel(ec.tryEnd(), cob), this.relabel(ec.handler(), cob), ec.catchType());
        } else if (coe instanceof LocalVariable) {
            LocalVariable lv = (LocalVariable)coe;
            cob.localVariable(lv.slot(), lv.name().stringValue(), lv.typeSymbol(), this.relabel(lv.startScope(), cob), this.relabel(lv.endScope(), cob));
        } else if (coe instanceof LocalVariableType) {
            LocalVariableType lvt = (LocalVariableType)coe;
            cob.localVariableType(lvt.slot(), lvt.name().stringValue(), lvt.signatureSymbol(), this.relabel(lvt.startScope(), cob), this.relabel(lvt.endScope(), cob));
        } else if (coe instanceof CharacterRange) {
            CharacterRange chr = (CharacterRange)coe;
            cob.characterRange(this.relabel(chr.startScope(), cob), this.relabel(chr.endScope(), cob), chr.characterRangeStart(), chr.characterRangeEnd(), chr.flags());
        } else {
            cob.with(coe);
        }
    }
}

