/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PreCollectionRecreateEvent;
import org.hibernate.event.spi.PreCollectionRecreateEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.stat.spi.StatisticsImplementor;

public final class CollectionRecreateAction
extends CollectionAction {
    public CollectionRecreateAction(PersistentCollection<?> collection, CollectionPersister persister, Object id, EventSource session) {
        super(persister, collection, id, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws HibernateException {
        PersistentCollection<?> collection = this.getCollection();
        this.preRecreate();
        EventSource session = this.getSession();
        CollectionPersister persister = this.getPersister();
        Object key = this.getKey();
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent event = eventMonitor.beginCollectionRecreateEvent();
        boolean success = false;
        try {
            persister.recreate(collection, key, session);
            success = true;
        }
        finally {
            eventMonitor.completeCollectionRecreateEvent(event, key, persister.getRole(), success, session);
        }
        session.getPersistenceContextInternal().getCollectionEntry(collection).afterAction(collection);
        this.evict();
        this.postRecreate();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.recreateCollection(persister.getRole());
        }
    }

    private void preRecreate() {
        this.getEventListenerGroups().eventListenerGroup_PRE_COLLECTION_RECREATE.fireLazyEventOnEachListener(this::newPreCollectionRecreateEvent, PreCollectionRecreateEventListener::onPreRecreateCollection);
    }

    private PreCollectionRecreateEvent newPreCollectionRecreateEvent() {
        return new PreCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
    }

    private void postRecreate() {
        this.getEventListenerGroups().eventListenerGroup_POST_COLLECTION_RECREATE.fireLazyEventOnEachListener(this::newPostCollectionRecreateEvent, PostCollectionRecreateEventListener::onPostRecreateCollection);
    }

    private PostCollectionRecreateEvent newPostCollectionRecreateEvent() {
        return new PostCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
    }
}

