---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes
---

# Comment utiliser des polices non standard dans Plain TeX ?

Plain TeX (conformément à sa description) ne fait rien d'extraordinaire avec les polices : 
il configure les polices dont Donald Knuth a jugé avoir besoin lors de ses travaux
et vous laisse faire le reste.

Pour utiliser autre chose que la valeur par défaut de Knuth, vous pouvez utiliser 
le mécanisme mis à disposition par Knuth, la primitive `\font`  :

```{noedit}
\font\mafonte=fontenonstandard
...
\mafonte
Texte utilisant fontenonstandard...
```

Le nom que vous utilisez (`fontenonstandard`, ci-dessus) est le nom du fichier `tfm` 
pour la police souhaitée.

Si vous souhaitez utiliser une version italique de `\mafonte`, 
vous devez à nouveau utiliser `\font`  :

```{noedit}
\font\mafonteita=fontenonstandard-italique
...
\mafonteita
Texte utilisant fontenonstandard en italique...
```

Tout cela est très élémentaire et sert à une utilisation simple des polices. 
Cependant, des problèmes peuvent se poser, le plus important étant la question 
des [encodages des polices](/2_programmation/encodage/notion_d_encodage). 
On ne voit presque jamais de nouvelles polices utilisant les encodages de polices 
assez excentriques de Knuth --- mais ces encodages sont intégrés à Plain TeX, 
de sorte que certaines macros de Plain TeX doivent être modifiées 
pour utiliser les polices. LaTeX contourne tous ces problèmes en utilisant 
un "schéma de sélection de polices" : le "NFSS" ("N" pour "nouveau", par opposition 
à ce qu'avait LaTeX 2.09) qui véhicule des informations séparées sur les polices 
que vous utilisez. Ainsi, les modifications apportées aux commandes spécifiques 
à l'encodage se produisent automatiquement.

Si vous souhaitez utiliser uniquement les polices 
*[European Computer](que_sont_les_fontes_ec)*, vous pouvez en principe utiliser 
l'ensemble <ctanpkg:ec-plain>, qui vous donne une version de Plain TeX 
que vous pouvez exécuter de la même manière que vous exécutez Plain TeX 
avec les polices *Computer Modern* d'origine, en appelant `tex`. 
Notez que <ctanpkg:ec-plain> étend également les polices *European Computer*, 
pour des raisons qui ne sont pas immédiatement claires, 
mais qui pourraient poser des problèmes si vous espérez utiliser 
des versions Type 1 des polices.

L'extension <ctanpkg:font_selection> fournit une sorte de solution intermédiaire : 
elle fournit la police et la taille de la police, mais pas la sélection de famille. 
Cela vous donne une liberté considérable, mais vous laisse coincé 
avec les polices *Computer Modern* d'origine. C'est une solution compacte, 
avec des avantages de ses inconvénients (et réciproquement).

D'autres approches du problème de Plain TeX (les extensions <ctanpkg:plnfss>, 
<ctanpkg:fontch> et <ctanpkg:ofs>) sortent du modèle Plain TeX 
pour tendre vers le type de sélection de polices fourni par ConTeXt et LaTeX :
une sélection de police qui permet de changer de famille, ainsi que de taille et de visage. 
Les extensions prévoient toutes l'utilisation d'encodages autres que l'OT1 de Knuth.

- <ctanpkg:plnfss> possède un ensemble plutôt basique de fonctionnalités 
  applicables aux familles de polices.  Cependant, il est capable d'utiliser
  les fichiers de description de police (`.fd`) créés pour LaTeX. Ceci est utile, 
  car la plupart des mécanismes modernes d'intégration des polices vectorielles 
  avec TeX génèrent des fichiers `.fd` dans leur processus.

- <ctanpkg:fontch> comporte des fonctionnalités spéciales pour les encodages T1 et TS1, 
  que vous sélectionnez à l'aide de commandes obscures, telles que la suivante qui permet
  d'obtenir l'encodage T1 :

  ```{noedit}
  \let\LMTone\relax
  \input fontch.tex
  ```

- <ctanpkg:ofs> semble être l'alternative la plus réfléchie et peut sélectionner 
  plusieurs encodages : en plus de T1, elle couvre l'encodage IL2, 
  privilégié en République tchèque et en Slovaquie. L'extension <ctanpkg:ofs> couvre 
  également les polices mathématiques, vous permettant le plaisir douteux 
  d'utiliser des polices telles que [pxfonts et txfonts](fontes_t1_pour_les_mathematiques).

- <ctanpkg:pdcmac> (pour Plain TeX) se veut un environnement complet 
  de préparation de documents, comme [Eplain](/1_generalites/glossaire/eplain). 
  L'un de ses composants est un système de sélection de polices, [pdcfsel](ctanpkg:pdcmac), 
  qui est plutôt simple mais suffisamment puissant pour de nombreuses utilisations. 
  L'extension ne précharge pas les polices : l'utilisateur doit déclarer les polices 
  que le document va utiliser, et l'extension fournit des commandes pour sélectionner 
  les polices selon ses besoins. Cette extension comprend une configuration 
  permettant d'utiliser les polices "standard" d'Adobe pour la composition du texte. 
  (Eplain lui-même ne semble pas proposer de système de sélection de polices.)

- <ctanpkg:font-change> adopte une approche assez différente : elle fournit (en fait) 
  une série de modèles qui peuvent être inclus dans un document pour modifier 
  l'utilisation des polices. La documentation de l'extension en illustre plutôt bien
  l'effet.

- Changer simplement la *taille* de la police dans un document 
  (c'est-à-dire sans changer la police par défaut elle-même) peut être fait 
  en utilisant l'extension plutôt simple <ctanpkg:varisize>, 
  qui propose des tailles de police allant de 7 points à 20 points (toutes nominales). 
  Les commandes de taille de police sont générées lorsque l'un des fichiers 
  de l'extension est chargé. Ainsi, `11pt.tex` définit une commande `\elevenpoint`. 
  Chacun des fichiers garantit qu'il existe une taille par défaut, 
  en définissant une commande `\tenpoint`.


:::{sources}
[Using non-standard fonts in Plain TeX](faquk:FAQ-fonts-pln)
:::