/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.latex.IndexLocation;
import java.util.TreeSet;
import java.util.Vector;

public class IndexEntry
implements Comparable<IndexEntry> {
    private String sort;
    private TeXObject entryValue;
    private TreeSet<IndexEntry> subEntries;
    private Vector<IndexLocation> locations;

    public IndexEntry(String string, TeXObject teXObject) {
        this.sort = string;
        this.entryValue = teXObject;
        this.subEntries = new TreeSet();
        this.locations = new Vector();
    }

    public void addLocation(IndexLocation indexLocation) {
        this.locations.add(indexLocation);
    }

    public IndexEntry addSubEntry(String string, TeXObject teXObject) {
        return this.addSubEntry(string, teXObject, null);
    }

    public IndexEntry addSubEntry(String string, TeXObject teXObject, IndexLocation indexLocation) {
        IndexEntry indexEntry = null;
        for (IndexEntry indexEntry2 : this.subEntries) {
            if (!string.equals(indexEntry2.sort)) continue;
            indexEntry = indexEntry2;
            break;
        }
        if (indexEntry == null) {
            indexEntry = new IndexEntry(string, teXObject);
            this.subEntries.add(indexEntry);
        }
        if (indexLocation != null) {
            indexEntry.addLocation(indexLocation);
        }
        return indexEntry;
    }

    @Override
    public int compareTo(IndexEntry indexEntry) {
        return this.sort.compareTo(indexEntry.sort);
    }
}

