/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.util.ApiTypeHelper;

public abstract class StatsAggregateBase
extends AggregateBase {
    @Nullable
    private final Double avg;
    @Nullable
    private final String avgAsString;
    private final long count;
    @Nullable
    private final Double max;
    @Nullable
    private final String maxAsString;
    @Nullable
    private final Double min;
    @Nullable
    private final String minAsString;
    private final double sum;
    @Nullable
    private final String sumAsString;

    protected StatsAggregateBase(AbstractBuilder<?> builder) {
        super(builder);
        this.avg = ((AbstractBuilder)builder).avg;
        this.avgAsString = ((AbstractBuilder)builder).avgAsString;
        this.count = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).count, this, "count");
        this.max = ((AbstractBuilder)builder).max;
        this.maxAsString = ((AbstractBuilder)builder).maxAsString;
        this.min = ((AbstractBuilder)builder).min;
        this.minAsString = ((AbstractBuilder)builder).minAsString;
        this.sum = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).sum, this, "sum");
        this.sumAsString = ((AbstractBuilder)builder).sumAsString;
    }

    @Nullable
    public final Double avg() {
        return this.avg;
    }

    @Nullable
    public final String avgAsString() {
        return this.avgAsString;
    }

    public final long count() {
        return this.count;
    }

    @Nullable
    public final Double max() {
        return this.max;
    }

    @Nullable
    public final String maxAsString() {
        return this.maxAsString;
    }

    @Nullable
    public final Double min() {
        return this.min;
    }

    @Nullable
    public final String minAsString() {
        return this.minAsString;
    }

    public final double sum() {
        return this.sum;
    }

    @Nullable
    public final String sumAsString() {
        return this.sumAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.avg != null) {
            generator.writeKey("avg");
            generator.write(this.avg.doubleValue());
        }
        if (this.avgAsString != null) {
            generator.writeKey("avg_as_string");
            generator.write(this.avgAsString);
        }
        generator.writeKey("count");
        generator.write(this.count);
        if (this.max != null) {
            generator.writeKey("max");
            generator.write(this.max.doubleValue());
        }
        if (this.maxAsString != null) {
            generator.writeKey("max_as_string");
            generator.write(this.maxAsString);
        }
        if (this.min != null) {
            generator.writeKey("min");
            generator.write(this.min.doubleValue());
        }
        if (this.minAsString != null) {
            generator.writeKey("min_as_string");
            generator.write(this.minAsString);
        }
        generator.writeKey("sum");
        generator.write(this.sum);
        if (this.sumAsString != null) {
            generator.writeKey("sum_as_string");
            generator.write(this.sumAsString);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupStatsAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        StatsAggregateBase.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::avg, JsonpDeserializer.doubleDeserializer(), "avg");
        op.add(AbstractBuilder::avgAsString, JsonpDeserializer.stringDeserializer(), "avg_as_string");
        op.add(AbstractBuilder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(AbstractBuilder::max, JsonpDeserializer.doubleDeserializer(), "max");
        op.add(AbstractBuilder::maxAsString, JsonpDeserializer.stringDeserializer(), "max_as_string");
        op.add(AbstractBuilder::min, JsonpDeserializer.doubleDeserializer(), "min");
        op.add(AbstractBuilder::minAsString, JsonpDeserializer.stringDeserializer(), "min_as_string");
        op.add(AbstractBuilder::sum, JsonpDeserializer.doubleDeserializer(), "sum");
        op.add(AbstractBuilder::sumAsString, JsonpDeserializer.stringDeserializer(), "sum_as_string");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.avg);
        result = 31 * result + Objects.hashCode(this.avgAsString);
        result = 31 * result + Long.hashCode(this.count);
        result = 31 * result + Objects.hashCode(this.max);
        result = 31 * result + Objects.hashCode(this.maxAsString);
        result = 31 * result + Objects.hashCode(this.min);
        result = 31 * result + Objects.hashCode(this.minAsString);
        result = 31 * result + Double.hashCode(this.sum);
        result = 31 * result + Objects.hashCode(this.sumAsString);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatsAggregateBase other = (StatsAggregateBase)o;
        return Objects.equals(this.avg, other.avg) && Objects.equals(this.avgAsString, other.avgAsString) && this.count == other.count && Objects.equals(this.max, other.max) && Objects.equals(this.maxAsString, other.maxAsString) && Objects.equals(this.min, other.min) && Objects.equals(this.minAsString, other.minAsString) && this.sum == other.sum && Objects.equals(this.sumAsString, other.sumAsString);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Double avg;
        @Nullable
        private String avgAsString;
        private Long count;
        @Nullable
        private Double max;
        @Nullable
        private String maxAsString;
        @Nullable
        private Double min;
        @Nullable
        private String minAsString;
        private Double sum;
        @Nullable
        private String sumAsString;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(StatsAggregateBase o) {
            super(o);
            this.avg = o.avg;
            this.avgAsString = o.avgAsString;
            this.count = o.count;
            this.max = o.max;
            this.maxAsString = o.maxAsString;
            this.min = o.min;
            this.minAsString = o.minAsString;
            this.sum = o.sum;
            this.sumAsString = o.sumAsString;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            super(o);
            this.avg = o.avg;
            this.avgAsString = o.avgAsString;
            this.count = o.count;
            this.max = o.max;
            this.maxAsString = o.maxAsString;
            this.min = o.min;
            this.minAsString = o.minAsString;
            this.sum = o.sum;
            this.sumAsString = o.sumAsString;
        }

        @Nonnull
        public final BuilderT avg(@Nullable Double value) {
            this.avg = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT avgAsString(@Nullable String value) {
            this.avgAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT count(long value) {
            this.count = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT max(@Nullable Double value) {
            this.max = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT maxAsString(@Nullable String value) {
            this.maxAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT min(@Nullable Double value) {
            this.min = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT minAsString(@Nullable String value) {
            this.minAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT sum(double value) {
            this.sum = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT sumAsString(@Nullable String value) {
            this.sumAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

