"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CellMenu = exports.CellMenuItem = exports.CellMenuSection = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
exports.CellMenuSection = ({ children }) => {
    return react_1.default.createElement("ul", { className: "cell-menu-section" }, children);
};
class CellMenuItem extends react_1.default.PureComponent {
    constructor() {
        super(...arguments);
        this.element = react_1.default.createRef();
        this.handleKeypress = (e) => {
            if (e.keyCode === 13 || e.keyCode === 32) {
                this.props.onClick && this.props.onClick();
            }
        };
        this.handleFocus = () => {
            if (this.props.focusWithin) {
                this.element.current.querySelector(":first-child").focus();
            }
        };
    }
    componentDidMount() {
        this.element.current.addEventListener("focus", this.handleFocus);
        this.element.current.addEventListener("keypress", this.handleKeypress);
    }
    componentWillUnmount() {
        this.element.current.removeEventListener("focus", this.handleFocus);
        this.element.current.removeEventListener("keypress", this.handleKeypress);
    }
    render() {
        const _a = this.props, { children, className, focusWithin } = _a, props = __rest(_a, ["children", "className", "focusWithin"]);
        return (react_1.default.createElement("li", Object.assign({ ref: this.element, className: classnames_1.default("cell-menu-item", className) }, props), children));
    }
}
exports.CellMenuItem = CellMenuItem;
exports.CellMenu = ({ visible, children }) => {
    return (react_1.default.createElement("div", { className: visible ? "cell-menu" : "cell-menu-hidden cell-menu" }, children));
};
//# sourceMappingURL=CellMenu.js.map