/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.registry;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.cache.FileAccess;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.ObjectHolder;
import org.gradle.cache.internal.FileBackedObjectHolder;
import org.gradle.cache.internal.FileIntegrityViolationSuppressingObjectHolderDecorator;
import org.gradle.cache.internal.OnDemandFileAccess;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.internal.inet.InetEndpoint;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.DaemonRegistryContent;
import org.gradle.launcher.daemon.registry.DaemonStopEvent;
import org.gradle.launcher.daemon.server.api.DaemonState;

public class PersistentDaemonRegistry
implements DaemonRegistry {
    private final ObjectHolder<DaemonRegistryContent> cache;
    private final Lock lock = new ReentrantLock();
    private final File registryFile;
    private static final Logger LOGGER = Logging.getLogger(PersistentDaemonRegistry.class);

    public PersistentDaemonRegistry(File registryFile, FileLockManager fileLockManager, Chmod chmod) {
        this.registryFile = registryFile;
        this.cache = new FileIntegrityViolationSuppressingObjectHolderDecorator((ObjectHolder)new FileBackedObjectHolder(registryFile, (FileAccess)new OnDemandFileAccess(registryFile, "daemon addresses registry", fileLockManager), DaemonRegistryContent.SERIALIZER, chmod));
    }

    @Override
    public List<DaemonInfo> getAll() {
        this.lock.lock();
        try {
            DaemonRegistryContent content = (DaemonRegistryContent)this.cache.get();
            if (content == null) {
                LinkedList<DaemonInfo> linkedList = new LinkedList<DaemonInfo>();
                return linkedList;
            }
            List<DaemonInfo> list = content.getInfos();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<DaemonInfo> getIdle() {
        return this.getDaemonsMatching(new Spec<DaemonInfo>(){

            public boolean isSatisfiedBy(DaemonInfo daemonInfo) {
                return daemonInfo.getState() == DaemonState.Idle;
            }
        });
    }

    @Override
    public List<DaemonInfo> getNotIdle() {
        return this.getDaemonsMatching(new Spec<DaemonInfo>(){

            public boolean isSatisfiedBy(DaemonInfo daemonInfo) {
                return daemonInfo.getState() != DaemonState.Idle;
            }
        });
    }

    @Override
    public List<DaemonInfo> getCanceled() {
        return this.getDaemonsMatching(new Spec<DaemonInfo>(){

            public boolean isSatisfiedBy(DaemonInfo daemonInfo) {
                return daemonInfo.getState() == DaemonState.Canceled;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DaemonInfo> getDaemonsMatching(Spec<DaemonInfo> spec) {
        this.lock.lock();
        try {
            LinkedList<DaemonInfo> out = new LinkedList<DaemonInfo>();
            List<DaemonInfo> all = this.getAll();
            for (DaemonInfo d : all) {
                if (!spec.isSatisfiedBy((Object)d)) continue;
                out.add(d);
            }
            LinkedList<DaemonInfo> linkedList = out;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remove(final Address address) {
        this.lock.lock();
        try {
            LOGGER.debug("Removing daemon address: {}", (Object)address);
            this.cache.update((ObjectHolder.UpdateAction)new ObjectHolder.UpdateAction<DaemonRegistryContent>(){

                public DaemonRegistryContent update(DaemonRegistryContent oldValue) {
                    if (oldValue == null) {
                        return oldValue;
                    }
                    oldValue.removeInfo(((InetEndpoint)address).getPort());
                    return oldValue;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void markState(final Address address, final DaemonState state) {
        this.lock.lock();
        try {
            LOGGER.debug("Marking busy by address: {}", (Object)address);
            this.cache.update((ObjectHolder.UpdateAction)new ObjectHolder.UpdateAction<DaemonRegistryContent>(){

                public DaemonRegistryContent update(DaemonRegistryContent oldValue) {
                    DaemonInfo daemonInfo;
                    DaemonInfo daemonInfo2 = daemonInfo = oldValue != null ? oldValue.getInfo(address) : null;
                    if (daemonInfo != null) {
                        daemonInfo.setState(state);
                    }
                    return oldValue;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void storeStopEvent(final DaemonStopEvent stopEvent) {
        this.lock.lock();
        try {
            LOGGER.debug("Storing daemon stop event with timestamp {}", (Object)stopEvent.getTimestamp().getTime());
            this.cache.update((ObjectHolder.UpdateAction)new ObjectHolder.UpdateAction<DaemonRegistryContent>(){

                public DaemonRegistryContent update(DaemonRegistryContent content) {
                    if (content == null) {
                        content = new DaemonRegistryContent();
                    }
                    content.addStopEvent(stopEvent);
                    return content;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<DaemonStopEvent> getStopEvents() {
        this.lock.lock();
        try {
            LOGGER.debug("Getting daemon stop events");
            DaemonRegistryContent content = (DaemonRegistryContent)this.cache.get();
            if (content == null) {
                LinkedList<DaemonStopEvent> linkedList = new LinkedList<DaemonStopEvent>();
                return linkedList;
            }
            List<DaemonStopEvent> list = content.getStopEvents();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeStopEvents(final Collection<DaemonStopEvent> events) {
        this.lock.lock();
        try {
            LOGGER.info("Removing {} daemon stop events from registry", (Object)events.size());
            this.cache.update((ObjectHolder.UpdateAction)new ObjectHolder.UpdateAction<DaemonRegistryContent>(){

                public DaemonRegistryContent update(DaemonRegistryContent content) {
                    if (content != null) {
                        content.removeStopEvents(events);
                    }
                    return content;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(DaemonInfo info) {
        final Address address = info.getAddress();
        final DaemonContext daemonContext = info.getContext();
        final byte[] token = info.getToken();
        final DaemonState state = info.getState();
        this.lock.lock();
        try {
            LOGGER.debug("Storing daemon address: {}, context: {}", (Object)address, (Object)daemonContext);
            this.cache.update((ObjectHolder.UpdateAction)new ObjectHolder.UpdateAction<DaemonRegistryContent>(){

                public DaemonRegistryContent update(DaemonRegistryContent oldValue) {
                    if (oldValue == null) {
                        oldValue = new DaemonRegistryContent();
                    }
                    DaemonInfo daemonInfo = new DaemonInfo(address, daemonContext, token, state);
                    oldValue.removeInfo(((InetEndpoint)address).getPort());
                    oldValue.setStatus(address, daemonInfo);
                    return oldValue;
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return String.format("PersistentDaemonRegistry[file=%s]", this.registryFile);
    }
}

