/**
 * Copyright 2022-2025 NVIDIA Corporation.  All rights reserved.
 *
 * Please refer to the NVIDIA end user license agreement (EULA) associated
 * with this source code for terms and conditions that govern your use of
 * this software. Any use, reproduction, disclosure, or distribution of
 * this software and related documentation outside the terms of the EULA
 * is strictly prohibited.
 *
 * This file is generated
 */

////////////////////////////////////////////////////////////////////////////////

#ifndef HELPER_CUPTI_ACTIVITY_ENUMS_H_
#define HELPER_CUPTI_ACTIVITY_ENUMS_H_

#pragma once

// Auto-generated header
#include <iostream>
#include <iomanip>
#include <cstdint>

// CUPTI headers
#include <cupti_activity.h>


static const char*
GetApiCallbackSiteString(
    CUpti_ApiCallbackSite e)
{
    switch(e)
    {
        case CUPTI_API_ENTER: return "ENTER";
        case CUPTI_API_EXIT: return "EXIT";
        case CUPTI_API_CBSITE_FORCE_INT: return "CBSITE_FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetCallbackDomainString(
    CUpti_CallbackDomain e)
{
    switch(e)
    {
        case CUPTI_CB_DOMAIN_INVALID: return "INVALID";
        case CUPTI_CB_DOMAIN_DRIVER_API: return "DRIVER_API";
        case CUPTI_CB_DOMAIN_RUNTIME_API: return "RUNTIME_API";
        case CUPTI_CB_DOMAIN_RESOURCE: return "RESOURCE";
        case CUPTI_CB_DOMAIN_SYNCHRONIZE: return "SYNCHRONIZE";
        case CUPTI_CB_DOMAIN_NVTX: return "NVTX";
        case CUPTI_CB_DOMAIN_STATE: return "STATE";
        case CUPTI_CB_DOMAIN_SIZE: return "SIZE";
        case CUPTI_CB_DOMAIN_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetCallbackIdResourceString(
    CUpti_CallbackIdResource e)
{
    switch(e)
    {
        case CUPTI_CBID_RESOURCE_INVALID: return "INVALID";
        case CUPTI_CBID_RESOURCE_CONTEXT_CREATED: return "CONTEXT_CREATED";
        case CUPTI_CBID_RESOURCE_CONTEXT_DESTROY_STARTING: return "CONTEXT_DESTROY_STARTING";
        case CUPTI_CBID_RESOURCE_STREAM_CREATED: return "STREAM_CREATED";
        case CUPTI_CBID_RESOURCE_STREAM_DESTROY_STARTING: return "STREAM_DESTROY_STARTING";
        case CUPTI_CBID_RESOURCE_CU_INIT_FINISHED: return "CU_INIT_FINISHED";
        case CUPTI_CBID_RESOURCE_MODULE_LOADED: return "MODULE_LOADED";
        case CUPTI_CBID_RESOURCE_MODULE_UNLOAD_STARTING: return "MODULE_UNLOAD_STARTING";
        case CUPTI_CBID_RESOURCE_MODULE_PROFILED: return "MODULE_PROFILED";
        case CUPTI_CBID_RESOURCE_GRAPH_CREATED: return "GRAPH_CREATED";
        case CUPTI_CBID_RESOURCE_GRAPH_DESTROY_STARTING: return "GRAPH_DESTROY_STARTING";
        case CUPTI_CBID_RESOURCE_GRAPH_CLONED: return "GRAPH_CLONED";
        case CUPTI_CBID_RESOURCE_GRAPHNODE_CREATE_STARTING: return "GRAPHNODE_CREATE_STARTING";
        case CUPTI_CBID_RESOURCE_GRAPHNODE_CREATED: return "GRAPHNODE_CREATED";
        case CUPTI_CBID_RESOURCE_GRAPHNODE_DESTROY_STARTING: return "GRAPHNODE_DESTROY_STARTING";
        case CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_CREATED: return "GRAPHNODE_DEPENDENCY_CREATED";
        case CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_DESTROY_STARTING: return "GRAPHNODE_DEPENDENCY_DESTROY_STARTING";
        case CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATE_STARTING: return "GRAPHEXEC_CREATE_STARTING";
        case CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATED: return "GRAPHEXEC_CREATED";
        case CUPTI_CBID_RESOURCE_GRAPHEXEC_DESTROY_STARTING: return "GRAPHEXEC_DESTROY_STARTING";
        case CUPTI_CBID_RESOURCE_GRAPHNODE_CLONED: return "GRAPHNODE_CLONED";
        case CUPTI_CBID_RESOURCE_STREAM_ATTRIBUTE_CHANGED: return "STREAM_ATTRIBUTE_CHANGED";
        case CUPTI_CBID_RESOURCE_GRAPH_NODE_UPDATED: return "GRAPH_NODE_UPDATED";
        case CUPTI_CBID_RESOURCE_GRAPH_NODE_SET_PARAMS: return "GRAPH_NODE_SET_PARAMS";
        case CUPTI_CBID_RESOURCE_SIZE: return "SIZE";
        case CUPTI_CBID_RESOURCE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetCallbackIdSyncString(
    CUpti_CallbackIdSync e)
{
    switch(e)
    {
        case CUPTI_CBID_SYNCHRONIZE_INVALID: return "INVALID";
        case CUPTI_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED: return "STREAM_SYNCHRONIZED";
        case CUPTI_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED: return "CONTEXT_SYNCHRONIZED";
        case CUPTI_CBID_SYNCHRONIZE_SIZE: return "SIZE";
        case CUPTI_CBID_SYNCHRONIZE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetCallbackIdStateString(
    CUpti_CallbackIdState e)
{
    switch(e)
    {
        case CUPTI_CBID_STATE_INVALID: return "INVALID";
        case CUPTI_CBID_STATE_FATAL_ERROR: return "FATAL_ERROR";
        case CUPTI_CBID_STATE_ERROR: return "ERROR";
        case CUPTI_CBID_STATE_WARNING: return "WARNING";
        case CUPTI_CBID_STATE_SIZE: return "SIZE";
        case CUPTI_CBID_STATE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityKindString(
    CUpti_ActivityKind e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_KIND_INVALID: return "INVALID";
        case CUPTI_ACTIVITY_KIND_MEMCPY: return "MEMCPY";
        case CUPTI_ACTIVITY_KIND_MEMSET: return "MEMSET";
        case CUPTI_ACTIVITY_KIND_KERNEL: return "KERNEL";
        case CUPTI_ACTIVITY_KIND_DRIVER: return "DRIVER";
        case CUPTI_ACTIVITY_KIND_RUNTIME: return "RUNTIME";
        case CUPTI_ACTIVITY_KIND_EVENT: return "EVENT";
        case CUPTI_ACTIVITY_KIND_METRIC: return "METRIC";
        case CUPTI_ACTIVITY_KIND_DEVICE: return "DEVICE";
        case CUPTI_ACTIVITY_KIND_CONTEXT: return "CONTEXT";
        case CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL: return "CONCURRENT_KERNEL";
        case CUPTI_ACTIVITY_KIND_NAME: return "NAME";
        case CUPTI_ACTIVITY_KIND_MARKER: return "MARKER";
        case CUPTI_ACTIVITY_KIND_MARKER_DATA: return "MARKER_DATA";
        case CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR: return "SOURCE_LOCATOR";
        case CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS: return "GLOBAL_ACCESS";
        case CUPTI_ACTIVITY_KIND_BRANCH: return "BRANCH";
        case CUPTI_ACTIVITY_KIND_OVERHEAD: return "OVERHEAD";
        case CUPTI_ACTIVITY_KIND_CDP_KERNEL: return "CDP_KERNEL";
        case CUPTI_ACTIVITY_KIND_PREEMPTION: return "PREEMPTION";
        case CUPTI_ACTIVITY_KIND_ENVIRONMENT: return "ENVIRONMENT";
        case CUPTI_ACTIVITY_KIND_EVENT_INSTANCE: return "EVENT_INSTANCE";
        case CUPTI_ACTIVITY_KIND_MEMCPY2: return "MEMCPY2";
        case CUPTI_ACTIVITY_KIND_METRIC_INSTANCE: return "METRIC_INSTANCE";
        case CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION: return "INSTRUCTION_EXECUTION";
        case CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER: return "UNIFIED_MEMORY_COUNTER";
        case CUPTI_ACTIVITY_KIND_FUNCTION: return "FUNCTION";
        case CUPTI_ACTIVITY_KIND_MODULE: return "MODULE";
        case CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE: return "DEVICE_ATTRIBUTE";
        case CUPTI_ACTIVITY_KIND_SHARED_ACCESS: return "SHARED_ACCESS";
        case CUPTI_ACTIVITY_KIND_PC_SAMPLING: return "PC_SAMPLING";
        case CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO: return "PC_SAMPLING_RECORD_INFO";
        case CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION: return "INSTRUCTION_CORRELATION";
        case CUPTI_ACTIVITY_KIND_OPENACC_DATA: return "OPENACC_DATA";
        case CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH: return "OPENACC_LAUNCH";
        case CUPTI_ACTIVITY_KIND_OPENACC_OTHER: return "OPENACC_OTHER";
        case CUPTI_ACTIVITY_KIND_CUDA_EVENT: return "CUDA_EVENT";
        case CUPTI_ACTIVITY_KIND_STREAM: return "STREAM";
        case CUPTI_ACTIVITY_KIND_SYNCHRONIZATION: return "SYNCHRONIZATION";
        case CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION: return "EXTERNAL_CORRELATION";
        case CUPTI_ACTIVITY_KIND_NVLINK: return "NVLINK";
        case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT: return "INSTANTANEOUS_EVENT";
        case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCE: return "INSTANTANEOUS_EVENT_INSTANCE";
        case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC: return "INSTANTANEOUS_METRIC";
        case CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE: return "INSTANTANEOUS_METRIC_INSTANCE";
        case CUPTI_ACTIVITY_KIND_MEMORY: return "MEMORY";
        case CUPTI_ACTIVITY_KIND_PCIE: return "PCIE";
        case CUPTI_ACTIVITY_KIND_OPENMP: return "OPENMP";
        case CUPTI_ACTIVITY_KIND_INTERNAL_LAUNCH_API: return "INTERNAL_LAUNCH_API";
        case CUPTI_ACTIVITY_KIND_MEMORY2: return "MEMORY2";
        case CUPTI_ACTIVITY_KIND_MEMORY_POOL: return "MEMORY_POOL";
        case CUPTI_ACTIVITY_KIND_GRAPH_TRACE: return "GRAPH_TRACE";
        case CUPTI_ACTIVITY_KIND_JIT: return "JIT";
        case CUPTI_ACTIVITY_KIND_DEVICE_GRAPH_TRACE: return "DEVICE_GRAPH_TRACE";
        case CUPTI_ACTIVITY_KIND_MEM_DECOMPRESS: return "MEM_DECOMPRESS";
        case CUPTI_ACTIVITY_KIND_CONFIDENTIAL_COMPUTE_ROTATION: return "CONFIDENTIAL_COMPUTE_ROTATION";
        case CUPTI_ACTIVITY_KIND_GRAPH_HOST_NODE: return "GRAPH_HOST_NODE";
        case CUPTI_ACTIVITY_KIND_COMPUTE_ENGINE_CTX_SWITCH: return "COMPUTE_ENGINE_CTX_SWITCH";
        case CUPTI_ACTIVITY_KIND_HOST_LAUNCH: return "HOST_LAUNCH";
        case CUPTI_ACTIVITY_KIND_COUNT: return "COUNT";
        case CUPTI_ACTIVITY_KIND_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityObjectKindString(
    CUpti_ActivityObjectKind e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_OBJECT_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_OBJECT_PROCESS: return "PROCESS";
        case CUPTI_ACTIVITY_OBJECT_THREAD: return "THREAD";
        case CUPTI_ACTIVITY_OBJECT_DEVICE: return "DEVICE";
        case CUPTI_ACTIVITY_OBJECT_CONTEXT: return "CONTEXT";
        case CUPTI_ACTIVITY_OBJECT_STREAM: return "STREAM";
        case CUPTI_ACTIVITY_OBJECT_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityOverheadKindString(
    CUpti_ActivityOverheadKind e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_OVERHEAD_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_OVERHEAD_DRIVER_COMPILER: return "DRIVER_COMPILER";
        case CUPTI_ACTIVITY_OVERHEAD_CUPTI_BUFFER_FLUSH: return "CUPTI_BUFFER_FLUSH";
        case CUPTI_ACTIVITY_OVERHEAD_CUPTI_INSTRUMENTATION: return "CUPTI_INSTRUMENTATION";
        case CUPTI_ACTIVITY_OVERHEAD_CUPTI_RESOURCE: return "CUPTI_RESOURCE";
        case CUPTI_ACTIVITY_OVERHEAD_RUNTIME_TRIGGERED_MODULE_LOADING: return "RUNTIME_TRIGGERED_MODULE_LOADING";
        case CUPTI_ACTIVITY_OVERHEAD_LAZY_FUNCTION_LOADING: return "LAZY_FUNCTION_LOADING";
        case CUPTI_ACTIVITY_OVERHEAD_COMMAND_BUFFER_FULL: return "COMMAND_BUFFER_FULL";
        case CUPTI_ACTIVITY_OVERHEAD_ACTIVITY_BUFFER_REQUEST: return "ACTIVITY_BUFFER_REQUEST";
        case CUPTI_ACTIVITY_OVERHEAD_UVM_ACTIVITY_INIT: return "UVM_ACTIVITY_INIT";
        case CUPTI_ACTIVITY_OVERHEAD_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityComputeApiKindString(
    CUpti_ActivityComputeApiKind e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_COMPUTE_API_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_COMPUTE_API_CUDA: return "CUDA";
        case CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPS: return "CUDA_MPS";
        case CUPTI_ACTIVITY_COMPUTE_API_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityPCSamplingStallReasonString(
    CUpti_ActivityPCSamplingStallReason e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALID: return "INVALID";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONE: return "NONE";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_INST_FETCH: return "INST_FETCH";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_EXEC_DEPENDENCY: return "EXEC_DEPENDENCY";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_DEPENDENCY: return "MEMORY_DEPENDENCY";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_TEXTURE: return "TEXTURE";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_SYNC: return "SYNC";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_CONSTANT_MEMORY_DEPENDENCY: return "CONSTANT_MEMORY_DEPENDENCY";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_PIPE_BUSY: return "PIPE_BUSY";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_THROTTLE: return "MEMORY_THROTTLE";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_NOT_SELECTED: return "NOT_SELECTED";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_OTHER: return "OTHER";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_SLEEPING: return "SLEEPING";
        case CUPTI_ACTIVITY_PC_SAMPLING_STALL_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityPCSamplingPeriodString(
    CUpti_ActivityPCSamplingPeriod e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_INVALID: return "INVALID";
        case CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MIN: return "MIN";
        case CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_LOW: return "LOW";
        case CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MID: return "MID";
        case CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_HIGH: return "HIGH";
        case CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MAX: return "MAX";
        case CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityMemcpyKindString(
    CUpti_ActivityMemcpyKind e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_MEMCPY_KIND_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_MEMCPY_KIND_HTOD: return "HTOD";
        case CUPTI_ACTIVITY_MEMCPY_KIND_DTOH: return "DTOH";
        case CUPTI_ACTIVITY_MEMCPY_KIND_HTOA: return "HTOA";
        case CUPTI_ACTIVITY_MEMCPY_KIND_ATOH: return "ATOH";
        case CUPTI_ACTIVITY_MEMCPY_KIND_ATOA: return "ATOA";
        case CUPTI_ACTIVITY_MEMCPY_KIND_ATOD: return "ATOD";
        case CUPTI_ACTIVITY_MEMCPY_KIND_DTOA: return "DTOA";
        case CUPTI_ACTIVITY_MEMCPY_KIND_DTOD: return "DTOD";
        case CUPTI_ACTIVITY_MEMCPY_KIND_HTOH: return "HTOH";
        case CUPTI_ACTIVITY_MEMCPY_KIND_PTOP: return "PTOP";
        case CUPTI_ACTIVITY_MEMCPY_KIND_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityMemoryKindString(
    CUpti_ActivityMemoryKind e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_MEMORY_KIND_PAGEABLE: return "PAGEABLE";
        case CUPTI_ACTIVITY_MEMORY_KIND_PINNED: return "PINNED";
        case CUPTI_ACTIVITY_MEMORY_KIND_DEVICE: return "DEVICE";
        case CUPTI_ACTIVITY_MEMORY_KIND_ARRAY: return "ARRAY";
        case CUPTI_ACTIVITY_MEMORY_KIND_MANAGED: return "MANAGED";
        case CUPTI_ACTIVITY_MEMORY_KIND_DEVICE_STATIC: return "DEVICE_STATIC";
        case CUPTI_ACTIVITY_MEMORY_KIND_MANAGED_STATIC: return "MANAGED_STATIC";
        case CUPTI_ACTIVITY_MEMORY_KIND_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityPreemptionKindString(
    CUpti_ActivityPreemptionKind e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_PREEMPTION_KIND_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_PREEMPTION_KIND_SAVE: return "SAVE";
        case CUPTI_ACTIVITY_PREEMPTION_KIND_RESTORE: return "RESTORE";
        case CUPTI_ACTIVITY_PREEMPTION_KIND_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityEnvironmentKindString(
    CUpti_ActivityEnvironmentKind e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_ENVIRONMENT_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_ENVIRONMENT_SPEED: return "SPEED";
        case CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE: return "TEMPERATURE";
        case CUPTI_ACTIVITY_ENVIRONMENT_POWER: return "POWER";
        case CUPTI_ACTIVITY_ENVIRONMENT_COOLING: return "COOLING";
        case CUPTI_ACTIVITY_ENVIRONMENT_COUNT: return "COUNT";
        case CUPTI_ACTIVITY_ENVIRONMENT_KIND_FORCE_INT: return "KIND_FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetEnvironmentClocksThrottleReasonString(
    CUpti_EnvironmentClocksThrottleReason e)
{
    switch(e)
    {
        case CUPTI_CLOCKS_THROTTLE_REASON_GPU_IDLE: return "GPU_IDLE";
        case CUPTI_CLOCKS_THROTTLE_REASON_USER_DEFINED_CLOCKS: return "USER_DEFINED_CLOCKS";
        case CUPTI_CLOCKS_THROTTLE_REASON_SW_POWER_CAP: return "SW_POWER_CAP";
        case CUPTI_CLOCKS_THROTTLE_REASON_HW_SLOWDOWN: return "HW_SLOWDOWN";
        case CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWN: return "UNKNOWN";
        case CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTED: return "UNSUPPORTED";
        case CUPTI_CLOCKS_THROTTLE_REASON_NONE: return "NONE";
        case CUPTI_CLOCKS_THROTTLE_REASON_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityUnifiedMemoryCounterScopeString(
    CUpti_ActivityUnifiedMemoryCounterScope e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_SINGLE_DEVICE: return "PROCESS_SINGLE_DEVICE";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_ALL_DEVICES: return "PROCESS_ALL_DEVICES";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_COUNT: return "COUNT";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityUnifiedMemoryCounterKindString(
    CUpti_ActivityUnifiedMemoryCounterKind e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_HTOD: return "BYTES_TRANSFER_HTOD";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOH: return "BYTES_TRANSFER_DTOH";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_CPU_PAGE_FAULT_COUNT: return "CPU_PAGE_FAULT_COUNT";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_GPU_PAGE_FAULT: return "GPU_PAGE_FAULT";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHING: return "THRASHING";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLING: return "THROTTLING";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_REMOTE_MAP: return "REMOTE_MAP";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOD: return "BYTES_TRANSFER_DTOD";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_COUNT: return "COUNT";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityUnifiedMemoryAccessTypeString(
    CUpti_ActivityUnifiedMemoryAccessType e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_READ: return "READ";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_WRITE: return "WRITE";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_ATOMIC: return "ATOMIC";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_PREFETCH: return "PREFETCH";
        default: return "<unknown>";
    }
}

static const char*
GetActivityUnifiedMemoryMigrationCauseString(
    CUpti_ActivityUnifiedMemoryMigrationCause e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_USER: return "USER";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_COHERENCE: return "COHERENCE";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_PREFETCH: return "PREFETCH";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_EVICTION: return "EVICTION";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_ACCESS_COUNTERS: return "ACCESS_COUNTERS";
        default: return "<unknown>";
    }
}

static const char*
GetActivityUnifiedMemoryRemoteMapCauseString(
    CUpti_ActivityUnifiedMemoryRemoteMapCause e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_COHERENCE: return "COHERENCE";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_THRASHING: return "THRASHING";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_POLICY: return "POLICY";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_OUT_OF_MEMORY: return "OUT_OF_MEMORY";
        case CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_EVICTION: return "EVICTION";
        default: return "<unknown>";
    }
}

static const char*
GetActivityInstructionClassString(
    CUpti_ActivityInstructionClass e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_32: return "FP_32";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_64: return "FP_64";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTEGER: return "INTEGER";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_BIT_CONVERSION: return "BIT_CONVERSION";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONTROL_FLOW: return "CONTROL_FLOW";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL: return "GLOBAL";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED: return "SHARED";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_LOCAL: return "LOCAL";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_GENERIC: return "GENERIC";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE: return "SURFACE";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONSTANT: return "CONSTANT";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_TEXTURE: return "TEXTURE";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL_ATOMIC: return "GLOBAL_ATOMIC";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED_ATOMIC: return "SHARED_ATOMIC";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE_ATOMIC: return "SURFACE_ATOMIC";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTER_THREAD_COMMUNICATION: return "INTER_THREAD_COMMUNICATION";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_BARRIER: return "BARRIER";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_MISCELLANEOUS: return "MISCELLANEOUS";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_16: return "FP_16";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNIFORM: return "UNIFORM";
        case CUPTI_ACTIVITY_INSTRUCTION_CLASS_KIND_FORCE_INT: return "KIND_FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityPartitionedGlobalCacheConfigString(
    CUpti_ActivityPartitionedGlobalCacheConfig e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_NOT_SUPPORTED: return "NOT_SUPPORTED";
        case CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_OFF: return "OFF";
        case CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ON: return "ON";
        case CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivitySynchronizationTypeString(
    CUpti_ActivitySynchronizationType e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_UNKNOWN: return "UNKNOWN";
        case CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_EVENT_SYNCHRONIZE: return "EVENT_SYNCHRONIZE";
        case CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_WAIT_EVENT: return "STREAM_WAIT_EVENT";
        case CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_SYNCHRONIZE: return "STREAM_SYNCHRONIZE";
        case CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_CONTEXT_SYNCHRONIZE: return "CONTEXT_SYNCHRONIZE";
        case CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityStreamFlagString(
    CUpti_ActivityStreamFlag e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_STREAM_CREATE_FLAG_UNKNOWN: return "FLAG_UNKNOWN";
        case CUPTI_ACTIVITY_STREAM_CREATE_FLAG_DEFAULT: return "FLAG_DEFAULT";
        case CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NON_BLOCKING: return "FLAG_NON_BLOCKING";
        case CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NULL: return "FLAG_NULL";
        case CUPTI_ACTIVITY_STREAM_CREATE_MASK: return "MASK";
        case CUPTI_ACTIVITY_STREAM_CREATE_FLAG_FORCE_INT: return "FLAG_FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetLinkFlagString(
    CUpti_LinkFlag e)
{
    switch(e)
    {
        case CUPTI_LINK_FLAG_INVALID: return "INVALID";
        case CUPTI_LINK_FLAG_PEER_ACCESS: return "PEER_ACCESS";
        case CUPTI_LINK_FLAG_SYSMEM_ACCESS: return "SYSMEM_ACCESS";
        case CUPTI_LINK_FLAG_PEER_ATOMICS: return "PEER_ATOMICS";
        case CUPTI_LINK_FLAG_SYSMEM_ATOMICS: return "SYSMEM_ATOMICS";
        case CUPTI_LINK_FLAG_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityMemoryOperationTypeString(
    CUpti_ActivityMemoryOperationType e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_INVALID: return "INVALID";
        case CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_ALLOCATION: return "ALLOCATION";
        case CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_RELEASE: return "RELEASE";
        case CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityMemoryPoolTypeString(
    CUpti_ActivityMemoryPoolType e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_MEMORY_POOL_TYPE_INVALID: return "INVALID";
        case CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL: return "LOCAL";
        case CUPTI_ACTIVITY_MEMORY_POOL_TYPE_IMPORTED: return "IMPORTED";
        case CUPTI_ACTIVITY_MEMORY_POOL_TYPE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityMemoryPoolOperationTypeString(
    CUpti_ActivityMemoryPoolOperationType e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_INVALID: return "INVALID";
        case CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_CREATED: return "CREATED";
        case CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_DESTROYED: return "DESTROYED";
        case CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_TRIMMED: return "TRIMMED";
        case CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetChannelTypeString(
    CUpti_ChannelType e)
{
    switch(e)
    {
        case CUPTI_CHANNEL_TYPE_INVALID: return "INVALID";
        case CUPTI_CHANNEL_TYPE_COMPUTE: return "COMPUTE";
        case CUPTI_CHANNEL_TYPE_ASYNC_MEMCPY: return "ASYNC_MEMCPY";
        case CUPTI_CHANNEL_TYPE_DECOMP: return "DECOMP";
        case CUPTI_CHANNEL_TYPE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetContextCigModeString(
    CUpti_ContextCigMode e)
{
    switch(e)
    {
        case CUPTI_CONTEXT_CIG_MODE_NONE: return "NONE";
        case CUPTI_CONTEXT_CIG_MODE_CIG: return "CIG";
        case CUPTI_CONTEXT_CIG_MODE_CIG_FALLBACK: return "CIG_FALLBACK";
        case CUPTI_CONTEXT_CIG_MODE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetNvtxExtPayloadTypeString(
    CUpti_NvtxExtPayloadType e)
{
    switch(e)
    {
        case CUPTI_NVTX_EXT_PAYLOAD_TYPE_UNKNOWN: return "UNKNOWN";
        case CUPTI_NVTX_EXT_PAYLOAD_TYPE_SCHEMA: return "SCHEMA";
        case CUPTI_NVTX_EXT_PAYLOAD_TYPE_ENUM: return "ENUM";
        case CUPTI_NVTX_EXT_PAYLOAD_TYPE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityLaunchTypeString(
    CUpti_ActivityLaunchType e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_LAUNCH_TYPE_REGULAR: return "REGULAR";
        case CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_SINGLE_DEVICE: return "COOPERATIVE_SINGLE_DEVICE";
        case CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_MULTI_DEVICE: return "COOPERATIVE_MULTI_DEVICE";
        case CUPTI_ACTIVITY_LAUNCH_TYPE_CBL_COMMANDLIST: return "CBL_COMMANDLIST";
        default: return "<unknown>";
    }
}

static const char*
GetFuncShmemLimitConfigString(
    CUpti_FuncShmemLimitConfig e)
{
    switch(e)
    {
        case CUPTI_FUNC_SHMEM_LIMIT_DEFAULT: return "DEFAULT";
        case CUPTI_FUNC_SHMEM_LIMIT_OPTIN: return "OPTIN";
        case CUPTI_FUNC_SHMEM_LIMIT_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetOpenAccEventKindString(
    CUpti_OpenAccEventKind e)
{
    switch(e)
    {
        case CUPTI_OPENACC_EVENT_KIND_INVALID: return "INVALID";
        case CUPTI_OPENACC_EVENT_KIND_DEVICE_INIT: return "DEVICE_INIT";
        case CUPTI_OPENACC_EVENT_KIND_DEVICE_SHUTDOWN: return "DEVICE_SHUTDOWN";
        case CUPTI_OPENACC_EVENT_KIND_RUNTIME_SHUTDOWN: return "RUNTIME_SHUTDOWN";
        case CUPTI_OPENACC_EVENT_KIND_ENQUEUE_LAUNCH: return "ENQUEUE_LAUNCH";
        case CUPTI_OPENACC_EVENT_KIND_ENQUEUE_UPLOAD: return "ENQUEUE_UPLOAD";
        case CUPTI_OPENACC_EVENT_KIND_ENQUEUE_DOWNLOAD: return "ENQUEUE_DOWNLOAD";
        case CUPTI_OPENACC_EVENT_KIND_WAIT: return "WAIT";
        case CUPTI_OPENACC_EVENT_KIND_IMPLICIT_WAIT: return "IMPLICIT_WAIT";
        case CUPTI_OPENACC_EVENT_KIND_COMPUTE_CONSTRUCT: return "COMPUTE_CONSTRUCT";
        case CUPTI_OPENACC_EVENT_KIND_UPDATE: return "UPDATE";
        case CUPTI_OPENACC_EVENT_KIND_ENTER_DATA: return "ENTER_DATA";
        case CUPTI_OPENACC_EVENT_KIND_EXIT_DATA: return "EXIT_DATA";
        case CUPTI_OPENACC_EVENT_KIND_CREATE: return "CREATE";
        case CUPTI_OPENACC_EVENT_KIND_DELETE: return "DELETE";
        case CUPTI_OPENACC_EVENT_KIND_ALLOC: return "ALLOC";
        case CUPTI_OPENACC_EVENT_KIND_FREE: return "FREE";
        case CUPTI_OPENACC_EVENT_KIND_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetOpenAccConstructKindString(
    CUpti_OpenAccConstructKind e)
{
    switch(e)
    {
        case CUPTI_OPENACC_CONSTRUCT_KIND_UNKNOWN: return "UNKNOWN";
        case CUPTI_OPENACC_CONSTRUCT_KIND_PARALLEL: return "PARALLEL";
        case CUPTI_OPENACC_CONSTRUCT_KIND_KERNELS: return "KERNELS";
        case CUPTI_OPENACC_CONSTRUCT_KIND_LOOP: return "LOOP";
        case CUPTI_OPENACC_CONSTRUCT_KIND_DATA: return "DATA";
        case CUPTI_OPENACC_CONSTRUCT_KIND_ENTER_DATA: return "ENTER_DATA";
        case CUPTI_OPENACC_CONSTRUCT_KIND_EXIT_DATA: return "EXIT_DATA";
        case CUPTI_OPENACC_CONSTRUCT_KIND_HOST_DATA: return "HOST_DATA";
        case CUPTI_OPENACC_CONSTRUCT_KIND_ATOMIC: return "ATOMIC";
        case CUPTI_OPENACC_CONSTRUCT_KIND_DECLARE: return "DECLARE";
        case CUPTI_OPENACC_CONSTRUCT_KIND_INIT: return "INIT";
        case CUPTI_OPENACC_CONSTRUCT_KIND_SHUTDOWN: return "SHUTDOWN";
        case CUPTI_OPENACC_CONSTRUCT_KIND_SET: return "SET";
        case CUPTI_OPENACC_CONSTRUCT_KIND_UPDATE: return "UPDATE";
        case CUPTI_OPENACC_CONSTRUCT_KIND_ROUTINE: return "ROUTINE";
        case CUPTI_OPENACC_CONSTRUCT_KIND_WAIT: return "WAIT";
        case CUPTI_OPENACC_CONSTRUCT_KIND_RUNTIME_API: return "RUNTIME_API";
        case CUPTI_OPENACC_CONSTRUCT_KIND_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetOpenMpEventKindString(
    CUpti_OpenMpEventKind e)
{
    switch(e)
    {
        case CUPTI_OPENMP_EVENT_KIND_INVALID: return "INVALID";
        case CUPTI_OPENMP_EVENT_KIND_PARALLEL: return "PARALLEL";
        case CUPTI_OPENMP_EVENT_KIND_TASK: return "TASK";
        case CUPTI_OPENMP_EVENT_KIND_THREAD: return "THREAD";
        case CUPTI_OPENMP_EVENT_KIND_IDLE: return "IDLE";
        case CUPTI_OPENMP_EVENT_KIND_WAIT_BARRIER: return "WAIT_BARRIER";
        case CUPTI_OPENMP_EVENT_KIND_WAIT_TASKWAIT: return "WAIT_TASKWAIT";
        case CUPTI_OPENMP_EVENT_KIND_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetExternalCorrelationKindString(
    CUpti_ExternalCorrelationKind e)
{
    switch(e)
    {
        case CUPTI_EXTERNAL_CORRELATION_KIND_INVALID: return "INVALID";
        case CUPTI_EXTERNAL_CORRELATION_KIND_UNKNOWN: return "UNKNOWN";
        case CUPTI_EXTERNAL_CORRELATION_KIND_OPENACC: return "OPENACC";
        case CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM0: return "CUSTOM0";
        case CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM1: return "CUSTOM1";
        case CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM2: return "CUSTOM2";
        case CUPTI_EXTERNAL_CORRELATION_KIND_SIZE: return "SIZE";
        case CUPTI_EXTERNAL_CORRELATION_KIND_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetDevTypeString(
    CUpti_DevType e)
{
    switch(e)
    {
        case CUPTI_DEV_TYPE_INVALID: return "INVALID";
        case CUPTI_DEV_TYPE_GPU: return "GPU";
        case CUPTI_DEV_TYPE_NPU: return "NPU";
        case CUPTI_DEV_TYPE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetPcieDeviceTypeString(
    CUpti_PcieDeviceType e)
{
    switch(e)
    {
        case CUPTI_PCIE_DEVICE_TYPE_GPU: return "GPU";
        case CUPTI_PCIE_DEVICE_TYPE_BRIDGE: return "BRIDGE";
        case CUPTI_PCIE_DEVICE_TYPE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetPcieGenString(
    CUpti_PcieGen e)
{
    switch(e)
    {
        case CUPTI_PCIE_GEN_GEN1: return "GEN1";
        case CUPTI_PCIE_GEN_GEN2: return "GEN2";
        case CUPTI_PCIE_GEN_GEN3: return "GEN3";
        case CUPTI_PCIE_GEN_GEN4: return "GEN4";
        case CUPTI_PCIE_GEN_GEN5: return "GEN5";
        case CUPTI_PCIE_GEN_GEN6: return "GEN6";
        case CUPTI_PCIE_GEN_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetConfidentialComputeRotationEventTypeString(
    CUpti_ConfidentialComputeRotationEventType e)
{
    switch(e)
    {
        case CUPTI_CONFIDENTIAL_COMPUTE_INVALID_ROTATION_EVENT: return "INVALID_ROTATION_EVENT";
        case CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_BLOCKED: return "KEY_ROTATION_CHANNEL_BLOCKED";
        case CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_DRAINED: return "KEY_ROTATION_CHANNEL_DRAINED";
        case CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_UNBLOCKED: return "KEY_ROTATION_CHANNEL_UNBLOCKED";
        case CUPTI_CONFIDENTIAL_COMPUTE_EVENT_TYPE_FORCE_INT: return "EVENT_TYPE_FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityJitEntryTypeString(
    CUpti_ActivityJitEntryType e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_JIT_ENTRY_INVALID: return "INVALID";
        case CUPTI_ACTIVITY_JIT_ENTRY_PTX_TO_CUBIN: return "PTX_TO_CUBIN";
        case CUPTI_ACTIVITY_JIT_ENTRY_NVVM_IR_TO_PTX: return "NVVM_IR_TO_PTX";
        case CUPTI_ACTIVITY_JIT_ENTRY_TYPE_FORCE_INT: return "TYPE_FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityJitOperationTypeString(
    CUpti_ActivityJitOperationType e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_JIT_OPERATION_INVALID: return "INVALID";
        case CUPTI_ACTIVITY_JIT_OPERATION_CACHE_LOAD: return "CACHE_LOAD";
        case CUPTI_ACTIVITY_JIT_OPERATION_CACHE_STORE: return "CACHE_STORE";
        case CUPTI_ACTIVITY_JIT_OPERATION_COMPILE: return "COMPILE";
        case CUPTI_ACTIVITY_JIT_OPERATION_TYPE_FORCE_INT: return "TYPE_FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetDeviceGraphLaunchModeString(
    CUpti_DeviceGraphLaunchMode e)
{
    switch(e)
    {
        case CUPTI_DEVICE_GRAPH_LAUNCH_MODE_INVALID: return "INVALID";
        case CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET: return "FIRE_AND_FORGET";
        case CUPTI_DEVICE_GRAPH_LAUNCH_MODE_TAIL: return "TAIL";
        case CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET_AS_SIBLING: return "FIRE_AND_FORGET_AS_SIBLING";
        default: return "<unknown>";
    }
}

static const char*
GetComputeEngineCtxSwitchOperationTypeString(
    CUpti_ComputeEngineCtxSwitchOperationType e)
{
    switch(e)
    {
        case CUPTI_COMPUTE_ENGINE_CTX_SWITCH_OPERATION_INVALID: return "INVALID";
        case CUPTI_COMPUTE_ENGINE_CTX_SWITCH_OPERATION_START: return "START";
        case CUPTI_COMPUTE_ENGINE_CTX_SWITCH_OPERATION_END: return "END";
        case CUPTI_COMPUTE_ENGINE_CTX_SWITCH_OPERATION_COUNT: return "COUNT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityAttributeString(
    CUpti_ActivityAttribute e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE: return "DEVICE_BUFFER_SIZE";
        case CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP: return "DEVICE_BUFFER_SIZE_CDP";
        case CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT: return "DEVICE_BUFFER_POOL_LIMIT";
        case CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE: return "PROFILING_SEMAPHORE_POOL_SIZE";
        case CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT: return "PROFILING_SEMAPHORE_POOL_LIMIT";
        case CUPTI_ACTIVITY_ATTR_ZEROED_OUT_ACTIVITY_BUFFER: return "ZEROED_OUT_ACTIVITY_BUFFER";
        case CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE: return "DEVICE_BUFFER_PRE_ALLOCATE_VALUE";
        case CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE: return "PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE";
        case CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNED: return "MEM_ALLOCATION_TYPE_HOST_PINNED";
        case CUPTI_ACTIVITY_ATTR_PER_THREAD_ACTIVITY_BUFFER: return "PER_THREAD_ACTIVITY_BUFFER";
        case CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_DEVICE_GRAPHS: return "DEVICE_BUFFER_SIZE_DEVICE_GRAPHS";
        case CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_FORCE_INT: return "DEVICE_BUFFER_FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetActivityThreadIdTypeString(
    CUpti_ActivityThreadIdType e)
{
    switch(e)
    {
        case CUPTI_ACTIVITY_THREAD_ID_TYPE_DEFAULT: return "DEFAULT";
        case CUPTI_ACTIVITY_THREAD_ID_TYPE_SYSTEM: return "SYSTEM";
        case CUPTI_ACTIVITY_THREAD_ID_TYPE_SIZE: return "SIZE";
        case CUPTI_ACTIVITY_THREAD_ID_TYPE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}

static const char*
GetDeviceVirtualizationModeString(
    CUpti_DeviceVirtualizationMode e)
{
    switch(e)
    {
        case CUPTI_DEVICE_VIRTUALIZATION_MODE_NONE: return "NONE";
        case CUPTI_DEVICE_VIRTUALIZATION_MODE_PASS_THROUGH: return "PASS_THROUGH";
        case CUPTI_DEVICE_VIRTUALIZATION_MODE_VIRTUAL_GPU: return "VIRTUAL_GPU";
        case CUPTI_DEVICE_VIRTUALIZATION_MODE_FORCE_INT: return "FORCE_INT";
        default: return "<unknown>";
    }
}


static CUpti_ActivityKind
GetActivityKindFromString(
    const char *pString)
{
    if (!pString)
    {
        std::cerr << "\n\nError: NULL string.\n\n";
        exit(-1);
    }
    if (!stricmp(pString, "INVALID"))
    {
        return CUPTI_ACTIVITY_KIND_INVALID;
    }
    else if (!stricmp(pString, "MEMCPY"))
    {
        return CUPTI_ACTIVITY_KIND_MEMCPY;
    }
    else if (!stricmp(pString, "MEMSET"))
    {
        return CUPTI_ACTIVITY_KIND_MEMSET;
    }
    else if (!stricmp(pString, "KERNEL"))
    {
        return CUPTI_ACTIVITY_KIND_KERNEL;
    }
    else if (!stricmp(pString, "DRIVER"))
    {
        return CUPTI_ACTIVITY_KIND_DRIVER;
    }
    else if (!stricmp(pString, "RUNTIME"))
    {
        return CUPTI_ACTIVITY_KIND_RUNTIME;
    }
    else if (!stricmp(pString, "EVENT"))
    {
        return CUPTI_ACTIVITY_KIND_EVENT;
    }
    else if (!stricmp(pString, "METRIC"))
    {
        return CUPTI_ACTIVITY_KIND_METRIC;
    }
    else if (!stricmp(pString, "DEVICE"))
    {
        return CUPTI_ACTIVITY_KIND_DEVICE;
    }
    else if (!stricmp(pString, "CONTEXT"))
    {
        return CUPTI_ACTIVITY_KIND_CONTEXT;
    }
    else if (!stricmp(pString, "CONCURRENT_KERNEL"))
    {
        return CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL;
    }
    else if (!stricmp(pString, "NAME"))
    {
        return CUPTI_ACTIVITY_KIND_NAME;
    }
    else if (!stricmp(pString, "MARKER"))
    {
        return CUPTI_ACTIVITY_KIND_MARKER;
    }
    else if (!stricmp(pString, "MARKER_DATA"))
    {
        return CUPTI_ACTIVITY_KIND_MARKER_DATA;
    }
    else if (!stricmp(pString, "SOURCE_LOCATOR"))
    {
        return CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR;
    }
    else if (!stricmp(pString, "GLOBAL_ACCESS"))
    {
        return CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS;
    }
    else if (!stricmp(pString, "BRANCH"))
    {
        return CUPTI_ACTIVITY_KIND_BRANCH;
    }
    else if (!stricmp(pString, "OVERHEAD"))
    {
        return CUPTI_ACTIVITY_KIND_OVERHEAD;
    }
    else if (!stricmp(pString, "CDP_KERNEL"))
    {
        return CUPTI_ACTIVITY_KIND_CDP_KERNEL;
    }
    else if (!stricmp(pString, "PREEMPTION"))
    {
        return CUPTI_ACTIVITY_KIND_PREEMPTION;
    }
    else if (!stricmp(pString, "ENVIRONMENT"))
    {
        return CUPTI_ACTIVITY_KIND_ENVIRONMENT;
    }
    else if (!stricmp(pString, "EVENT_INSTANCE"))
    {
        return CUPTI_ACTIVITY_KIND_EVENT_INSTANCE;
    }
    else if (!stricmp(pString, "MEMCPY2"))
    {
        return CUPTI_ACTIVITY_KIND_MEMCPY2;
    }
    else if (!stricmp(pString, "METRIC_INSTANCE"))
    {
        return CUPTI_ACTIVITY_KIND_METRIC_INSTANCE;
    }
    else if (!stricmp(pString, "INSTRUCTION_EXECUTION"))
    {
        return CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION;
    }
    else if (!stricmp(pString, "UNIFIED_MEMORY_COUNTER"))
    {
        return CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER;
    }
    else if (!stricmp(pString, "FUNCTION"))
    {
        return CUPTI_ACTIVITY_KIND_FUNCTION;
    }
    else if (!stricmp(pString, "MODULE"))
    {
        return CUPTI_ACTIVITY_KIND_MODULE;
    }
    else if (!stricmp(pString, "DEVICE_ATTRIBUTE"))
    {
        return CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE;
    }
    else if (!stricmp(pString, "SHARED_ACCESS"))
    {
        return CUPTI_ACTIVITY_KIND_SHARED_ACCESS;
    }
    else if (!stricmp(pString, "PC_SAMPLING"))
    {
        return CUPTI_ACTIVITY_KIND_PC_SAMPLING;
    }
    else if (!stricmp(pString, "PC_SAMPLING_RECORD_INFO"))
    {
        return CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO;
    }
    else if (!stricmp(pString, "INSTRUCTION_CORRELATION"))
    {
        return CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION;
    }
    else if (!stricmp(pString, "OPENACC_DATA"))
    {
        return CUPTI_ACTIVITY_KIND_OPENACC_DATA;
    }
    else if (!stricmp(pString, "OPENACC_LAUNCH"))
    {
        return CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH;
    }
    else if (!stricmp(pString, "OPENACC_OTHER"))
    {
        return CUPTI_ACTIVITY_KIND_OPENACC_OTHER;
    }
    else if (!stricmp(pString, "CUDA_EVENT"))
    {
        return CUPTI_ACTIVITY_KIND_CUDA_EVENT;
    }
    else if (!stricmp(pString, "STREAM"))
    {
        return CUPTI_ACTIVITY_KIND_STREAM;
    }
    else if (!stricmp(pString, "SYNCHRONIZATION"))
    {
        return CUPTI_ACTIVITY_KIND_SYNCHRONIZATION;
    }
    else if (!stricmp(pString, "EXTERNAL_CORRELATION"))
    {
        return CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION;
    }
    else if (!stricmp(pString, "NVLINK"))
    {
        return CUPTI_ACTIVITY_KIND_NVLINK;
    }
    else if (!stricmp(pString, "INSTANTANEOUS_EVENT"))
    {
        return CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT;
    }
    else if (!stricmp(pString, "INSTANTANEOUS_EVENT_INSTANCE"))
    {
        return CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCE;
    }
    else if (!stricmp(pString, "INSTANTANEOUS_METRIC"))
    {
        return CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC;
    }
    else if (!stricmp(pString, "INSTANTANEOUS_METRIC_INSTANCE"))
    {
        return CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE;
    }
    else if (!stricmp(pString, "MEMORY"))
    {
        return CUPTI_ACTIVITY_KIND_MEMORY;
    }
    else if (!stricmp(pString, "PCIE"))
    {
        return CUPTI_ACTIVITY_KIND_PCIE;
    }
    else if (!stricmp(pString, "OPENMP"))
    {
        return CUPTI_ACTIVITY_KIND_OPENMP;
    }
    else if (!stricmp(pString, "INTERNAL_LAUNCH_API"))
    {
        return CUPTI_ACTIVITY_KIND_INTERNAL_LAUNCH_API;
    }
    else if (!stricmp(pString, "MEMORY2"))
    {
        return CUPTI_ACTIVITY_KIND_MEMORY2;
    }
    else if (!stricmp(pString, "MEMORY_POOL"))
    {
        return CUPTI_ACTIVITY_KIND_MEMORY_POOL;
    }
    else if (!stricmp(pString, "GRAPH_TRACE"))
    {
        return CUPTI_ACTIVITY_KIND_GRAPH_TRACE;
    }
    else if (!stricmp(pString, "JIT"))
    {
        return CUPTI_ACTIVITY_KIND_JIT;
    }
    else if (!stricmp(pString, "DEVICE_GRAPH_TRACE"))
    {
        return CUPTI_ACTIVITY_KIND_DEVICE_GRAPH_TRACE;
    }
    else if (!stricmp(pString, "MEM_DECOMPRESS"))
    {
        return CUPTI_ACTIVITY_KIND_MEM_DECOMPRESS;
    }
    else if (!stricmp(pString, "CONFIDENTIAL_COMPUTE_ROTATION"))
    {
        return CUPTI_ACTIVITY_KIND_CONFIDENTIAL_COMPUTE_ROTATION;
    }
    else if (!stricmp(pString, "GRAPH_HOST_NODE"))
    {
        return CUPTI_ACTIVITY_KIND_GRAPH_HOST_NODE;
    }
    else if (!stricmp(pString, "COMPUTE_ENGINE_CTX_SWITCH"))
    {
        return CUPTI_ACTIVITY_KIND_COMPUTE_ENGINE_CTX_SWITCH;
    }
    else if (!stricmp(pString, "HOST_LAUNCH"))
    {
        return CUPTI_ACTIVITY_KIND_HOST_LAUNCH;
    }
    else if (!stricmp(pString, "COUNT"))
    {
        return CUPTI_ACTIVITY_KIND_COUNT;
    }
    else if (!stricmp(pString, "FORCE_INT"))
    {
        return CUPTI_ACTIVITY_KIND_FORCE_INT;
    }
    else
    {
        std::cerr << "\n\nError: Invalid string " << pString << " cannot be converted to CUPTI Activity Kind.\n\n";
        return CUPTI_ACTIVITY_KIND_INVALID;
    }
}


#endif // HELPER_CUPTI_ACTIVITY_ENUMS_H_