/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.subversion.javahl.util.TunnelChannel;

class ResponseChannel
extends TunnelChannel
implements WritableByteChannel {
    private ResponseChannel(long l) {
        super(l);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        AtomicLong atomicLong = this.nativeChannel;
        synchronized (atomicLong) {
            long l = this.nativeChannel.get();
            if (l != 0L) {
                try {
                    return ResponseChannel.nativeWrite(l, byteBuffer);
                }
                catch (IOException iOException) {
                    this.nativeChannel.set(0L);
                    throw iOException;
                }
            }
            throw new ClosedChannelException();
        }
    }

    private static native int nativeWrite(long var0, ByteBuffer var2) throws IOException;
}

