# This file has been autogenerated by the pywayland scanner

# Copyright 2014 © Stephen "Lyude" Chandler Paul
# Copyright 2015-2016 © Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .zwp_tablet_pad_ring_v2 import ZwpTabletPadRingV2
from .zwp_tablet_pad_strip_v2 import ZwpTabletPadStripV2


class ZwpTabletPadGroupV2(Interface):
    """A set of buttons, rings and strips

    A pad group describes a distinct (sub)set of buttons, rings and strips
    present in the tablet. The criteria of this grouping is usually positional,
    eg. if a tablet has buttons on the left and right side, 2 groups will be
    presented. The physical arrangement of groups is undisclosed and may change
    on the fly.

    Pad groups will announce their features during pad initialization. Between
    the corresponding wp_tablet_pad.group event and wp_tablet_pad_group.done,
    the pad group will announce the buttons, rings and strips contained in it,
    plus the number of supported modes.

    Modes are a mechanism to allow multiple groups of actions for every element
    in the pad group. The number of groups and available modes in each is
    persistent across device plugs. The current mode is user-switchable, it
    will be announced through the wp_tablet_pad_group.mode_switch event both
    whenever it is switched, and after wp_tablet_pad.enter.

    The current mode logically applies to all elements in the pad group,
    although it is at clients' discretion whether to actually perform different
    actions, and/or issue the respective .set_feedback requests to notify the
    compositor. See the wp_tablet_pad_group.mode_switch event for more details.
    """

    name = "zwp_tablet_pad_group_v2"
    version = 1


class ZwpTabletPadGroupV2Proxy(Proxy[ZwpTabletPadGroupV2]):
    interface = ZwpTabletPadGroupV2

    @ZwpTabletPadGroupV2.request()
    def destroy(self) -> None:
        """Destroy the pad object

        Destroy the wp_tablet_pad_group object. Objects created from this
        object are unaffected and should be destroyed separately.
        """
        self._marshal(0)
        self._destroy()


class ZwpTabletPadGroupV2Resource(Resource):
    interface = ZwpTabletPadGroupV2

    @ZwpTabletPadGroupV2.event(
        Argument(ArgumentType.Array),
    )
    def buttons(self, buttons: list) -> None:
        """Buttons announced

        Sent on wp_tablet_pad_group initialization to announce the available
        buttons in the group. Button indices start at 0, a button may only be
        in one group at a time.

        This event is first sent in the initial burst of events before the
        wp_tablet_pad_group.done event.

        Some buttons are reserved by the compositor. These buttons may not be
        assigned to any wp_tablet_pad_group. Compositors may broadcast this
        event in the case of changes to the mapping of these reserved buttons.
        If the compositor happens to reserve all buttons in a group, this event
        will be sent with an empty array.

        :param buttons:
            buttons in this group
        :type buttons:
            `ArgumentType.Array`
        """
        self._post_event(0, buttons)

    @ZwpTabletPadGroupV2.event(
        Argument(ArgumentType.NewId, interface=ZwpTabletPadRingV2),
    )
    def ring(self, ring: ZwpTabletPadRingV2) -> None:
        """Ring announced

        Sent on wp_tablet_pad_group initialization to announce available rings.
        One event is sent for each ring available on this pad group.

        This event is sent in the initial burst of events before the
        wp_tablet_pad_group.done event.

        :param ring:
        :type ring:
            :class:`~pywayland.protocol.tablet_v2.ZwpTabletPadRingV2`
        """
        self._post_event(1, ring)

    @ZwpTabletPadGroupV2.event(
        Argument(ArgumentType.NewId, interface=ZwpTabletPadStripV2),
    )
    def strip(self, strip: ZwpTabletPadStripV2) -> None:
        """Strip announced

        Sent on wp_tablet_pad initialization to announce available strips. One
        event is sent for each strip available on this pad group.

        This event is sent in the initial burst of events before the
        wp_tablet_pad_group.done event.

        :param strip:
        :type strip:
            :class:`~pywayland.protocol.tablet_v2.ZwpTabletPadStripV2`
        """
        self._post_event(2, strip)

    @ZwpTabletPadGroupV2.event(
        Argument(ArgumentType.Uint),
    )
    def modes(self, modes: int) -> None:
        """Mode-switch ability announced

        Sent on wp_tablet_pad_group initialization to announce that the pad
        group may switch between modes. A client may use a mode to store a
        specific configuration for buttons, rings and strips and use the
        wl_tablet_pad_group.mode_switch event to toggle between these
        configurations. Mode indices start at 0.

        Switching modes is compositor-dependent. See the
        wp_tablet_pad_group.mode_switch event for more details.

        This event is sent in the initial burst of events before the
        wp_tablet_pad_group.done event. This event is only sent when more than
        more than one mode is available.

        :param modes:
            the number of modes
        :type modes:
            `ArgumentType.Uint`
        """
        self._post_event(3, modes)

    @ZwpTabletPadGroupV2.event()
    def done(self) -> None:
        """Tablet group description events sequence complete

        This event is sent immediately to signal the end of the initial burst
        of descriptive events. A client may consider the static description of
        the tablet to be complete and finalize initialization of the tablet
        group.
        """
        self._post_event(4)

    @ZwpTabletPadGroupV2.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def mode_switch(self, time: int, serial: int, mode: int) -> None:
        """Mode switch event

        Notification that the mode was switched.

        A mode applies to all buttons, rings and strips in a group
        simultaneously, but a client is not required to assign different
        actions for each mode. For example, a client may have mode-specific
        button mappings but map the ring to vertical scrolling in all modes.
        Mode indices start at 0.

        Switching modes is compositor-dependent. The compositor may provide
        visual cues to the user about the mode, e.g. by toggling LEDs on the
        tablet device. Mode-switching may be software-controlled or controlled
        by one or more physical buttons. For example, on a Wacom Intuos Pro,
        the button inside the ring may be assigned to switch between modes.

        The compositor will also send this event after wp_tablet_pad.enter on
        each group in order to notify of the current mode. Groups that only
        feature one mode will use mode=0 when emitting this event.

        If a button action in the new mode differs from the action in the
        previous mode, the client should immediately issue a
        wp_tablet_pad.set_feedback request for each changed button.

        If a ring or strip action in the new mode differs from the action in
        the previous mode, the client should immediately issue a
        wp_tablet_ring.set_feedback or wp_tablet_strip.set_feedback request for
        each changed ring or strip.

        :param time:
            the time of the event with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        :param serial:
        :type serial:
            `ArgumentType.Uint`
        :param mode:
            the new mode of the pad
        :type mode:
            `ArgumentType.Uint`
        """
        self._post_event(5, time, serial, mode)


class ZwpTabletPadGroupV2Global(Global):
    interface = ZwpTabletPadGroupV2


ZwpTabletPadGroupV2._gen_c()
ZwpTabletPadGroupV2.proxy_class = ZwpTabletPadGroupV2Proxy
ZwpTabletPadGroupV2.resource_class = ZwpTabletPadGroupV2Resource
ZwpTabletPadGroupV2.global_class = ZwpTabletPadGroupV2Global
