/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLConfiguration;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLSocketImpl;

final class SSLServerSocketImpl
extends SSLServerSocket {
    private final SSLContextImpl sslContext;
    private final SSLConfiguration sslConfig;

    SSLServerSocketImpl(SSLContextImpl sSLContextImpl) throws IOException {
        this.sslContext = sSLContextImpl;
        this.sslConfig = new SSLConfiguration(sSLContextImpl, false);
        this.sslConfig.isClientMode = false;
    }

    SSLServerSocketImpl(SSLContextImpl sSLContextImpl, int n, int n2) throws IOException {
        super(n, n2);
        this.sslContext = sSLContextImpl;
        this.sslConfig = new SSLConfiguration(sSLContextImpl, false);
        this.sslConfig.isClientMode = false;
    }

    SSLServerSocketImpl(SSLContextImpl sSLContextImpl, int n, int n2, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
        this.sslContext = sSLContextImpl;
        this.sslConfig = new SSLConfiguration(sSLContextImpl, false);
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return CipherSuite.namesOf(this.sslConfig.enabledCipherSuites);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.sslConfig.enabledCipherSuites = CipherSuite.validValuesOf(stringArray);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return CipherSuite.namesOf(this.sslContext.getSupportedCipherSuites());
    }

    @Override
    public String[] getSupportedProtocols() {
        return ProtocolVersion.toStringArray(this.sslContext.getSupportedProtocolVersions());
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return ProtocolVersion.toStringArray(this.sslConfig.enabledProtocols);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Protocols cannot be null");
        }
        this.sslConfig.enabledProtocols = ProtocolVersion.namesOf(stringArray);
    }

    @Override
    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslConfig.clientAuthType = bl ? ClientAuthType.CLIENT_AUTH_REQUIRED : ClientAuthType.CLIENT_AUTH_NONE;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED;
    }

    @Override
    public synchronized void setWantClientAuth(boolean bl) {
        this.sslConfig.clientAuthType = bl ? ClientAuthType.CLIENT_AUTH_REQUESTED : ClientAuthType.CLIENT_AUTH_NONE;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUESTED;
    }

    @Override
    public synchronized void setUseClientMode(boolean bl) {
        if (this.sslConfig.isClientMode != bl) {
            if (this.sslContext.isDefaultProtocolVesions(this.sslConfig.enabledProtocols)) {
                this.sslConfig.enabledProtocols = this.sslContext.getDefaultProtocolVersions(!bl);
            }
            if (this.sslContext.isDefaultCipherSuiteList(this.sslConfig.enabledCipherSuites)) {
                this.sslConfig.enabledCipherSuites = this.sslContext.getDefaultCipherSuites(!bl);
            }
            this.sslConfig.toggleClientMode();
        }
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.sslConfig.isClientMode;
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean bl) {
        this.sslConfig.enableSessionCreation = bl;
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.sslConfig.enableSessionCreation;
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return this.sslConfig.getSSLParameters();
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        this.sslConfig.setSSLParameters(sSLParameters);
    }

    @Override
    public Socket accept() throws IOException {
        SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(this.sslContext, this.sslConfig);
        this.implAccept(sSLSocketImpl);
        sSLSocketImpl.doneConnect();
        return sSLSocketImpl;
    }

    @Override
    public String toString() {
        return "[SSL: " + super.toString() + "]";
    }
}

