/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.shared.models;

import com.azul.crs.com.fasterxml.jackson.annotation.JsonFormat;
import com.azul.crs.shared.models.Payload;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Schema
extends Payload {
    private final String entity;
    private final List<Field> fields;

    public Schema() {
        this("", Collections.emptyList());
    }

    public Schema(String entity, List<Field> fields) {
        this.entity = entity;
        this.fields = fields;
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Map<String, List<ComparisonOperation>> getTypes() {
        return Type.getTypes();
    }

    public String getEntity() {
        return this.entity;
    }

    @JsonFormat(shape=JsonFormat.Shape.OBJECT)
    public static enum ComparisonOperation {
        EQUAL("=", "Equals to"),
        NOT_EQUAL("!=", "Not equal"),
        LESS("<", "Less"),
        LESS_OR_EQUAL("<=", "Less or equal"),
        GREATER(">", "Greater"),
        GREATER_OR_EQUAL(">=", "Greater or equal"),
        IN("IN", "One of"),
        RANGE("RANGE", "In range"),
        CONTAINS("CONTAINS", "Contains substring"),
        LIKE("LIKE", "Like (regexp)");

        private final String name;
        private final String displayName;

        private ComparisonOperation(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static List<ComparisonOperation> allExcept(ComparisonOperation ... except) {
            List<ComparisonOperation> exceptList = Arrays.asList(except);
            return Arrays.stream(ComparisonOperation.values()).filter(e -> !exceptList.contains(e)).collect(Collectors.toList());
        }
    }

    public static enum LogicalOperation {
        AND("AND"),
        OR("OR");

        private final String displayName;

        private LogicalOperation(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static class Field {
        private final String name;
        private final String qualifiedName;
        private final String displayName;
        private final Type type;
        private final Integer decimalPlaces;

        public Field(Field other) {
            this.name = other.getName();
            this.qualifiedName = other.getQualifiedName();
            this.type = other.getType();
            this.decimalPlaces = other.decimalPlaces;
            this.displayName = other.getDisplayName();
        }

        public Field() {
            this("", "", Type.OBJECT);
        }

        public Field(String prefix, String name, Type type) {
            this(prefix, name, name, type);
        }

        public Field(String prefix, String name, String displayName, Type type) {
            this(prefix, name, displayName, type, null);
        }

        public Field(String prefix, String name, String displayName, Type type, Integer decimalPlaces) {
            this.name = name;
            this.qualifiedName = prefix == null ? name : prefix + '.' + name;
            this.type = type;
            this.decimalPlaces = decimalPlaces;
            this.displayName = displayName == null ? name : displayName;
        }

        public String getName() {
            return this.name;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Integer getDecimalPlaces() {
            return this.decimalPlaces;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return "Field{name='" + this.name + '\'' + ", qualifiedName='" + this.qualifiedName + '\'' + ", displayName='" + this.displayName + '\'' + ", type=" + (Object)((Object)this.type) + '}';
        }
    }

    public static enum Type {
        NUMERIC(ComparisonOperation.allExcept(ComparisonOperation.LIKE, ComparisonOperation.CONTAINS)),
        STRING(ComparisonOperation.allExcept(new ComparisonOperation[0])),
        BOOLEAN(Arrays.asList(ComparisonOperation.EQUAL, ComparisonOperation.NOT_EQUAL)),
        DATETIME(ComparisonOperation.allExcept(ComparisonOperation.LIKE, ComparisonOperation.CONTAINS)),
        OBJECT(Collections.emptyList());

        private final List<ComparisonOperation> operations;

        private Type(List<ComparisonOperation> operations) {
            this.operations = Collections.unmodifiableList(operations);
        }

        public List<ComparisonOperation> getOperations() {
            return this.operations;
        }

        public static Map<String, List<ComparisonOperation>> getTypes() {
            HashMap<String, List<ComparisonOperation>> result = new HashMap<String, List<ComparisonOperation>>();
            for (Type type : Type.values()) {
                result.put(type.name(), type.getOperations());
            }
            return result;
        }
    }
}

