/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.FileTailerListener;
import com.azul.crs.shared.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileTailer
implements ClientService {
    private static final int DEFAULT_DELAY_TIMEOUT = 1000;
    private static final int DEFAULT_BUFSIZE = 4096;
    private static final int EOF = -1;
    protected final String serviceName;
    protected final File file;
    protected final byte[] inputBuf;
    protected final long delayTimeout;
    protected final boolean fromEnd;
    protected final boolean completeOnStop;
    protected final FileTailerListener listener;
    protected volatile boolean running;
    protected volatile long deadlineTimeCount;
    protected Thread thread;

    protected FileTailer(String serviceName, File file, FileTailerListener listener, long delayTimeout, boolean fromEnd, boolean completeOnStop, int bufSize) {
        this.file = file;
        this.delayTimeout = delayTimeout;
        this.fromEnd = fromEnd;
        this.completeOnStop = completeOnStop;
        this.inputBuf = new byte[bufSize];
        this.listener = listener;
        this.serviceName = serviceName == null ? ClientService.super.serviceName() : serviceName;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException(this.serviceName() + " is running already");
        }
        this.running = true;
        this.thread = new Thread(this::run);
        this.thread.setDaemon(true);
        this.thread.setName("CRSFileTailer");
        this.thread.start();
    }

    @Override
    public synchronized void stop(long deadline) {
        if (!this.running) {
            throw new IllegalStateException("File tailer has not been started");
        }
        try {
            this.running = false;
            this.thread.interrupt();
            this.deadlineTimeCount = deadline;
            long timeoutMs = -Utils.elapsedTimeMillis(this.deadlineTimeCount);
            if (timeoutMs > 0L) {
                this.thread.join(timeoutMs);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void run() {
        block32: {
            FileInputStream reader = null;
            try {
                long checkTime = 0L;
                long position = 0L;
                this.logger().info("looking for file %s", this.file.getName());
                while (this.running && reader == null) {
                    try {
                        reader = new FileInputStream(this.file);
                    }
                    catch (FileNotFoundException e) {
                        this.listener.fileNotFound();
                    }
                    if (reader == null) {
                        Thread.sleep(this.delayTimeout);
                        continue;
                    }
                    try {
                        position = this.fromEnd ? reader.skip(this.file.length()) : this.readBytes(reader);
                        checkTime = this.file.lastModified();
                    }
                    catch (IOException ioe) {
                        this.listener.handle(ioe);
                    }
                }
                this.logger().info("tailing file %s", this.file.getName());
                while (this.running) {
                    boolean newer = this.file.lastModified() > checkTime;
                    long length = this.file.length();
                    if (length < position) {
                        this.listener.fileRotated("");
                        try {
                            FileInputStream saved = reader;
                            Throwable throwable = null;
                            try {
                                reader = new FileInputStream(this.file);
                                this.readBytes(saved);
                                position = 0L;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (saved == null) continue;
                                if (throwable != null) {
                                    try {
                                        saved.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                saved.close();
                            }
                        }
                        catch (FileNotFoundException e) {
                            this.listener.fileNotFound();
                            Thread.sleep(this.delayTimeout);
                        }
                        continue;
                    }
                    if (length > position) {
                        position += this.readBytes(reader);
                        checkTime = this.file.lastModified();
                    } else if (newer) {
                        try {
                            reader = new FileInputStream(this.file);
                            position = this.readBytes(reader);
                            checkTime = this.file.lastModified();
                        }
                        catch (FileNotFoundException e) {
                            this.listener.fileNotFound();
                            Thread.sleep(this.delayTimeout);
                        }
                    }
                    Thread.sleep(this.delayTimeout);
                }
                this.closeReader(reader);
                this.running = false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.listener.interrupted();
            }
            catch (Exception e2) {
                this.listener.handle(e2);
                break block32;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeReader(reader);
                this.running = false;
            }
        }
    }

    protected void closeReader(FileInputStream reader) {
        if (reader != null) {
            try {
                if (this.completeOnStop) {
                    this.readBytes(reader);
                }
                reader.close();
            }
            catch (IOException e) {
                this.listener.handle(e);
            }
        }
    }

    protected long readBytes(FileInputStream reader) {
        int total = 0;
        try {
            while (this.running || this.completeOnStop && Utils.currentTimeCount() < this.deadlineTimeCount) {
                int num;
                int n = num = reader.available() > 0 ? reader.read(this.inputBuf) : -1;
                if (num <= 0) break;
                total += num;
                this.listener.handle(this.inputBuf, num);
            }
            this.listener.eofReached();
            return total;
        }
        catch (IOException ioe) {
            this.listener.handle(ioe);
            return total;
        }
    }

    public static class Builder<T extends Builder> {
        protected File file;
        protected FileTailerListener listener;
        protected long delayTimeout = 1000L;
        protected int bufSize = 4096;
        protected boolean fromEnd = false;
        protected boolean completeOnStop = true;
        protected String serviceName;

        public Builder(File file) {
            this.file = file;
        }

        public T listener(FileTailerListener listener) {
            this.listener = listener;
            return (T)this;
        }

        public T delayTimeout(long delayTimeout) {
            this.delayTimeout = delayTimeout;
            return (T)this;
        }

        public T bufSize(int bufSize) {
            this.bufSize = bufSize;
            return (T)this;
        }

        public T fromEnd(boolean fromEnd) {
            this.fromEnd = fromEnd;
            return (T)this;
        }

        public T completeOnStop(boolean completeOnStop) {
            this.completeOnStop = completeOnStop;
            return (T)this;
        }

        public T serviceName(String serviceName) {
            this.serviceName = serviceName;
            return (T)this;
        }

        public FileTailer build() {
            return new FileTailer(this.serviceName, this.file, this.listener, this.delayTimeout, this.fromEnd, this.completeOnStop, this.bufSize);
        }
    }
}

