/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.util.logging.Logger;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class PerformanceMetrics {
    private final AtomicLong communicationMillis = new AtomicLong();
    private final AtomicLong numBytesOut = new AtomicLong();
    private final AtomicLong numBytesIn = new AtomicLong();
    private long shutdownMillis;
    private final AtomicLong preShutdownMillis = new AtomicLong();
    private final AtomicLong numEvents = new AtomicLong();
    private final AtomicLong numEventBatches = new AtomicLong();
    private final AtomicLong[] numEventHistogram = new AtomicLong[20];
    private final AtomicLong numConnections = new AtomicLong();
    private final AtomicLong handshakeMillis = new AtomicLong();
    private final AtomicInteger maxQueueLength = new AtomicInteger();
    private final AtomicLong numBytesInArtifacts = new AtomicLong();
    private final AtomicLong numClassLoads = new AtomicLong();
    private final AtomicLong numMethodEntries = new AtomicLong();
    private static final Map<String, Number> fieldDesc = new HashMap<String, Number>();
    private static PerformanceMetrics instance;

    static void init() {
        instance = new PerformanceMetrics();
        for (int i = 0; i < PerformanceMetrics.instance.numEventHistogram.length; ++i) {
            PerformanceMetrics.instance.numEventHistogram[i] = new AtomicLong();
        }
        for (Field f : PerformanceMetrics.class.getDeclaredFields()) {
            if (!Number.class.isAssignableFrom(f.getType())) continue;
            try {
                fieldDesc.put(f.getName(), (Number)f.get(instance));
            }
            catch (IllegalAccessException shouldNotHappen) {
                shouldNotHappen.printStackTrace();
            }
        }
    }

    static void logNetworkTime(long duration) {
        PerformanceMetrics.instance.communicationMillis.addAndGet(duration);
    }

    static void logHandshakeTime(long duration) {
        PerformanceMetrics.instance.handshakeMillis.addAndGet(duration);
        PerformanceMetrics.instance.numConnections.incrementAndGet();
    }

    static void logBytes(long in, long out) {
        PerformanceMetrics.instance.numBytesIn.addAndGet(in);
        PerformanceMetrics.instance.numBytesOut.addAndGet(out);
    }

    static void logShutdown(long duration) {
        PerformanceMetrics.instance.shutdownMillis = duration;
    }

    public static void logEventBatch(long size) {
        PerformanceMetrics.instance.numEvents.addAndGet(size);
        PerformanceMetrics.instance.numEventBatches.incrementAndGet();
        PerformanceMetrics.instance.numEventHistogram[(int)(Math.log(size) / Math.log(2.0))].incrementAndGet();
    }

    public static void logClassLoads(long count) {
        PerformanceMetrics.instance.numClassLoads.addAndGet(count);
    }

    public static void logMethodEntries(long count) {
        PerformanceMetrics.instance.numMethodEntries.addAndGet(count);
    }

    public static void logEventQueueLength(int size) {
        int prev;
        AtomicInteger l = PerformanceMetrics.instance.maxQueueLength;
        while ((prev = l.get()) < size && !l.compareAndSet(prev, size)) {
        }
    }

    public static Map logPreShutdown(long duration) {
        PerformanceMetrics.instance.preShutdownMillis.set(duration);
        return instance.toEventPayload();
    }

    public static void logArtifactBytes(long bytes) {
        PerformanceMetrics.instance.numBytesInArtifacts.addAndGet(bytes);
    }

    private Map toEventPayload() {
        HashMap<String, String> data = new HashMap<String, String>();
        for (Map.Entry<String, Number> e : fieldDesc.entrySet()) {
            data.put(e.getKey(), e.getValue().toString());
        }
        return data;
    }

    static void report() {
        Logger logger = Logger.getLogger(PerformanceMetrics.class);
        if (logger.isEnabled(Logger.Level.INFO)) {
            StringBuilder numEventsHistogram = new StringBuilder();
            for (int i = 0; i < PerformanceMetrics.instance.numEventHistogram.length; ++i) {
                numEventsHistogram.append(PerformanceMetrics.instance.numEventHistogram[i].get()).append(' ');
            }
            logger.info("total communication duration %.3fs\nnumber of connections established %d, %.3fs spent in handshake\ntotal bytes in %.3fM\ntotal event data bytes out %.3fM\ntotal artifacts bytes %.3fM\nmaximum queue length %d\nshutdown delay %.3fs (pre %.3fs)\nclasses loaded %d\nmethods invoked %d\nevents sent %d batches %d [%s]\n", (double)PerformanceMetrics.instance.communicationMillis.get() / 1000.0, PerformanceMetrics.instance.numConnections.get(), (double)PerformanceMetrics.instance.handshakeMillis.get() / 1000.0, (double)PerformanceMetrics.instance.numBytesIn.get() / 1024.0 / 1024.0, (double)PerformanceMetrics.instance.numBytesOut.get() / 1024.0 / 1024.0, (double)PerformanceMetrics.instance.numBytesInArtifacts.get() / 1024.0 / 1024.0, PerformanceMetrics.instance.maxQueueLength.get(), (double)PerformanceMetrics.instance.shutdownMillis / 1000.0, (double)PerformanceMetrics.instance.preShutdownMillis.get() / 1000.0, PerformanceMetrics.instance.numClassLoads.get(), PerformanceMetrics.instance.numMethodEntries.get(), PerformanceMetrics.instance.numEvents.get(), PerformanceMetrics.instance.numEventBatches.get(), numEventsHistogram.toString());
        }
    }
}

