/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import sun.misc.BASE64Encoder;
import sun.net.www.MessageHeader;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;
import sun.tools.jar.JarException;
import sun.tools.jar.Manifest;

public class SignatureFile {
    static final boolean debug = false;
    private Vector<MessageHeader> entries = new Vector();
    static final String[] hashes = new String[]{"SHA"};
    private Manifest manifest;
    private String rawName;
    private PKCS7 signatureBlock;
    private Hashtable<String, MessageDigest> digests = new Hashtable();

    static final void debug(String string) {
    }

    private SignatureFile(String string) throws JarException {
        this.entries = new Vector();
        if (string != null) {
            if (string.length() > 8 || string.indexOf(46) != -1) {
                throw new JarException("invalid file name");
            }
            this.rawName = string.toUpperCase(Locale.ENGLISH);
        }
    }

    private SignatureFile(String string, boolean bl) throws JarException {
        this(string);
        if (bl) {
            MessageHeader messageHeader = new MessageHeader();
            messageHeader.set("Signature-Version", "1.0");
            this.entries.addElement(messageHeader);
        }
    }

    public SignatureFile(Manifest manifest, String string) throws JarException {
        this(string, true);
        this.manifest = manifest;
        Enumeration<MessageHeader> enumeration = manifest.entries();
        while (enumeration.hasMoreElements()) {
            MessageHeader messageHeader = enumeration.nextElement();
            String string2 = messageHeader.findValue("Name");
            if (string2 == null) continue;
            this.add(string2);
        }
    }

    public SignatureFile(Manifest manifest, String[] stringArray, String string) throws JarException {
        this(string, true);
        this.manifest = manifest;
        this.add(stringArray);
    }

    public SignatureFile(InputStream inputStream, String string) throws IOException {
        this(string);
        while (inputStream.available() > 0) {
            MessageHeader messageHeader = new MessageHeader(inputStream);
            this.entries.addElement(messageHeader);
        }
    }

    public SignatureFile(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public SignatureFile(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public String getName() {
        return "META-INF/" + this.rawName + ".SF";
    }

    public String getBlockName() {
        SignerInfo signerInfo;
        String string;
        String string2 = "DSA";
        if (this.signatureBlock != null && (string = AlgorithmId.getEncAlgFromSigAlg(string2 = (signerInfo = this.signatureBlock.getSignerInfos()[0]).getDigestEncryptionAlgorithmId().getName())) != null) {
            string2 = string;
        }
        return "META-INF/" + this.rawName + "." + string2;
    }

    public PKCS7 getBlock() {
        return this.signatureBlock;
    }

    public void setBlock(PKCS7 pKCS7) {
        this.signatureBlock = pKCS7;
    }

    public void add(String[] stringArray) throws JarException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.add(stringArray[i]);
        }
    }

    public void add(String string) throws JarException {
        MessageHeader messageHeader;
        MessageHeader messageHeader2 = this.manifest.getEntry(string);
        if (messageHeader2 == null) {
            throw new JarException("entry " + string + " not in manifest");
        }
        try {
            messageHeader = this.computeEntry(messageHeader2);
        }
        catch (IOException iOException) {
            throw new JarException(iOException.getMessage());
        }
        this.entries.addElement(messageHeader);
    }

    public MessageHeader getEntry(String string) {
        Enumeration<MessageHeader> enumeration = this.entries();
        while (enumeration.hasMoreElements()) {
            MessageHeader messageHeader = enumeration.nextElement();
            if (!string.equals(messageHeader.findValue("Name"))) continue;
            return messageHeader;
        }
        return null;
    }

    public MessageHeader entryAt(int n) {
        return this.entries.elementAt(n);
    }

    public Enumeration<MessageHeader> entries() {
        return this.entries.elements();
    }

    private MessageHeader computeEntry(MessageHeader messageHeader) throws IOException {
        MessageHeader messageHeader2 = new MessageHeader();
        String string = messageHeader.findValue("Name");
        if (string == null) {
            return null;
        }
        messageHeader2.set("Name", string);
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        try {
            for (int i = 0; i < hashes.length; ++i) {
                MessageDigest messageDigest = this.getDigest(hashes[i]);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                messageHeader.print(printStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byte[] byArray2 = messageDigest.digest(byArray);
                messageHeader2.set(hashes[i] + "-Digest", bASE64Encoder.encode(byArray2));
            }
            return messageHeader2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JarException(noSuchAlgorithmException.getMessage());
        }
    }

    private MessageDigest getDigest(String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = this.digests.get(string);
        if (messageDigest == null) {
            messageDigest = MessageDigest.getInstance(string);
            this.digests.put(string, messageDigest);
        }
        messageDigest.reset();
        return messageDigest;
    }

    public void stream(OutputStream outputStream) throws IOException {
        MessageHeader messageHeader = this.entries.elementAt(0);
        if (messageHeader.findValue("Signature-Version") == null) {
            throw new JarException("Signature file requires Signature-Version: 1.0 in 1st header");
        }
        PrintStream printStream = new PrintStream(outputStream);
        messageHeader.print(printStream);
        for (int i = 1; i < this.entries.size(); ++i) {
            MessageHeader messageHeader2 = this.entries.elementAt(i);
            messageHeader2.print(printStream);
        }
    }
}

