/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.Normalizer;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;
import sun.net.idn.Punycode;
import sun.net.idn.StringPrep;
import sun.net.util.IPAddressUtil;
import sun.security.ssl.Krb5Helper;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;
import sun.text.normalizer.UCharacterIterator;

public class HostnameChecker {
    public static final byte TYPE_TLS = 1;
    private static final HostnameChecker INSTANCE_TLS;
    public static final byte TYPE_LDAP = 2;
    private static final HostnameChecker INSTANCE_LDAP;
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;
    private final byte checkType;
    private static final String ACE_PREFIX = "xn--";
    private static final int ACE_PREFIX_LENGTH;
    private static final int MAX_LABEL_LENGTH = 63;
    private static StringPrep namePrep;

    private HostnameChecker(byte by) {
        this.checkType = by;
    }

    public static HostnameChecker getInstance(byte by) {
        if (by == 1) {
            return INSTANCE_TLS;
        }
        if (by == 2) {
            return INSTANCE_LDAP;
        }
        throw new IllegalArgumentException("Unknown check type: " + by);
    }

    public void match(String string, X509Certificate x509Certificate) throws CertificateException {
        if (HostnameChecker.isIpAddress(string)) {
            HostnameChecker.matchIP(string, x509Certificate);
        } else {
            this.matchDNS(string, x509Certificate);
        }
    }

    public static boolean match(String string, Principal principal) {
        String string2 = HostnameChecker.getServerName(principal);
        return string.equalsIgnoreCase(string2);
    }

    public static String getServerName(Principal principal) {
        return Krb5Helper.getPrincipalHostName((Principal)principal);
    }

    private static boolean isIpAddress(String string) {
        return IPAddressUtil.isIPv4LiteralAddress(string) || IPAddressUtil.isIPv6LiteralAddress(string);
    }

    private static void matchIP(String string, X509Certificate x509Certificate) throws CertificateException {
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection == null) {
            throw new CertificateException("No subject alternative names present");
        }
        for (List<?> list : collection) {
            if ((Integer)list.get(0) != 7) continue;
            String string2 = (String)list.get(1);
            if (string.equalsIgnoreCase(string2)) {
                return;
            }
            try {
                if (!InetAddress.getByName(string).equals(InetAddress.getByName(string2))) continue;
                return;
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (SecurityException securityException) {
            }
        }
        throw new CertificateException("No subject alternative names matching IP address " + string + " found");
    }

    private void matchDNS(String string, X509Certificate x509Certificate) throws CertificateException {
        X500Name x500Name;
        Object object;
        Object object2;
        try {
            HostnameChecker.checkHostName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertificateException("Illegal given domain name: " + string, illegalArgumentException);
        }
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection != null) {
            boolean bl = false;
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (List)object2.next();
                if ((Integer)object.get(0) != 2) continue;
                bl = true;
                String string2 = (String)object.get(1);
                if (!this.isMatched(string, string2)) continue;
                return;
            }
            if (bl) {
                throw new CertificateException("No subject alternative DNS name matching " + string + " found.");
            }
        }
        if ((object2 = (x500Name = HostnameChecker.getSubjectX500Name(x509Certificate)).findMostSpecificAttribute(X500Name.commonName_oid)) != null) {
            try {
                object = ((DerValue)object2).getAsString();
                if (!Normalizer.isNormalized((CharSequence)object, Normalizer.Form.NFKC)) {
                    throw new CertificateException("Not a formal name " + (String)object);
                }
                if (this.isMatched(string, (String)object)) {
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = "No name matching " + string + " found";
        throw new CertificateException((String)object);
    }

    public static X500Name getSubjectX500Name(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            Principal principal = x509Certificate.getSubjectDN();
            if (principal instanceof X500Name) {
                return (X500Name)principal;
            }
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            return new X500Name(x500Principal.getEncoded());
        }
        catch (IOException iOException) {
            throw (CertificateParsingException)new CertificateParsingException().initCause(iOException);
        }
    }

    private boolean isMatched(String string, String string2) {
        try {
            HostnameChecker.checkHostName(string2.replace('*', 'z'));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (this.checkType == 1) {
            return HostnameChecker.matchAllWildcards(string, string2);
        }
        if (this.checkType == 2) {
            return HostnameChecker.matchLeftmostWildcard(string, string2);
        }
        return false;
    }

    private static boolean matchAllWildcards(String string, String string2) {
        string = string.toLowerCase(Locale.ENGLISH);
        string2 = string2.toLowerCase(Locale.ENGLISH);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        if (stringTokenizer.countTokens() != stringTokenizer2.countTokens()) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            if (HostnameChecker.matchWildCards(stringTokenizer.nextToken(), stringTokenizer2.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean matchLeftmostWildcard(String string, String string2) {
        string = string.toLowerCase(Locale.ENGLISH);
        string2 = string2.toLowerCase(Locale.ENGLISH);
        int n = string2.indexOf(".");
        int n2 = string.indexOf(".");
        if (n == -1) {
            n = string2.length();
        }
        if (n2 == -1) {
            n2 = string.length();
        }
        if (HostnameChecker.matchWildCards(string.substring(0, n2), string2.substring(0, n))) {
            return string2.substring(n).equals(string.substring(n2));
        }
        return false;
    }

    private static boolean matchWildCards(String string, String string2) {
        int n = string2.indexOf("*");
        if (n == -1) {
            return string.equals(string2);
        }
        boolean bl = true;
        String string3 = "";
        String string4 = string2;
        while (n != -1) {
            string3 = string4.substring(0, n);
            string4 = string4.substring(n + 1);
            int n2 = string.indexOf(string3);
            if (n2 == -1 || bl && n2 != 0) {
                return false;
            }
            bl = false;
            string = string.substring(n2 + string3.length());
            n = string4.indexOf("*");
        }
        return string.endsWith(string4);
    }

    private static void checkHostName(String string) {
        string = HostnameChecker.toASCII(Objects.requireNonNull(string, "Server name value of host_name cannot be null"), 2);
        string.getBytes(StandardCharsets.US_ASCII);
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Server name value of host_name cannot be empty");
        }
        if (string.endsWith(".")) {
            throw new IllegalArgumentException("Server name value of host_name cannot have the trailing dot");
        }
    }

    private static String toASCII(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (HostnameChecker.isRootLabel(string)) {
            return ".";
        }
        while (n2 < string.length()) {
            n3 = HostnameChecker.searchDots(string, n2);
            stringBuffer.append(HostnameChecker.toASCIIInternal(string.substring(n2, n3), n));
            if (n3 != string.length()) {
                stringBuffer.append('.');
            }
            n2 = n3 + 1;
        }
        return stringBuffer.toString();
    }

    private static String toASCIIInternal(String string, int n) {
        boolean bl;
        StringBuffer stringBuffer;
        boolean bl2 = HostnameChecker.isAllASCII(string);
        if (!bl2) {
            UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(string);
            try {
                stringBuffer = namePrep.prepare(uCharacterIterator, n);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(parseException);
            }
        } else {
            stringBuffer = new StringBuffer(string);
        }
        if (stringBuffer.length() == 0) {
            throw new IllegalArgumentException("Empty label is not a legal name");
        }
        boolean bl3 = bl = (n & 2) != 0;
        if (bl) {
            for (int i = 0; i < stringBuffer.length(); ++i) {
                char c = stringBuffer.charAt(i);
                if (!HostnameChecker.isNonLDHAsciiCodePoint(c)) continue;
                throw new IllegalArgumentException("Contains non-LDH ASCII characters");
            }
            if (stringBuffer.charAt(0) == '-' || stringBuffer.charAt(stringBuffer.length() - 1) == '-') {
                throw new IllegalArgumentException("Has leading or trailing hyphen");
            }
        }
        if (!bl2 && !HostnameChecker.isAllASCII(stringBuffer.toString())) {
            if (!HostnameChecker.startsWithACEPrefix(stringBuffer)) {
                try {
                    stringBuffer = Punycode.encode(stringBuffer, null);
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException(parseException);
                }
                stringBuffer = HostnameChecker.toASCIILower(stringBuffer);
                stringBuffer.insert(0, ACE_PREFIX);
            } else {
                throw new IllegalArgumentException("The input starts with the ACE Prefix");
            }
        }
        if (stringBuffer.length() > 63) {
            throw new IllegalArgumentException("The label in the input is too long");
        }
        return stringBuffer.toString();
    }

    private static boolean isNonLDHAsciiCodePoint(int n) {
        return 0 <= n && n <= 44 || 46 <= n && n <= 47 || 58 <= n && n <= 64 || 91 <= n && n <= 96 || 123 <= n && n <= 127;
    }

    private static int searchDots(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length() && !HostnameChecker.isLabelSeparator(string.charAt(n2)); ++n2) {
        }
        return n2;
    }

    private static boolean isRootLabel(String string) {
        return string.length() == 1 && HostnameChecker.isLabelSeparator(string.charAt(0));
    }

    private static boolean isLabelSeparator(char c) {
        return c == '.' || c == '\u3002' || c == '\uff0e' || c == '\uff61';
    }

    private static boolean startsWithACEPrefix(StringBuffer stringBuffer) {
        boolean bl = true;
        if (stringBuffer.length() < ACE_PREFIX_LENGTH) {
            return false;
        }
        for (int i = 0; i < ACE_PREFIX_LENGTH; ++i) {
            if (HostnameChecker.toASCIILower(stringBuffer.charAt(i)) == ACE_PREFIX.charAt(i)) continue;
            bl = false;
        }
        return bl;
    }

    private static char toASCIILower(char c) {
        if ('A' <= c && c <= 'Z') {
            return (char)(c + 97 - 65);
        }
        return c;
    }

    private static StringBuffer toASCIILower(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            stringBuffer2.append(HostnameChecker.toASCIILower(stringBuffer.charAt(i)));
        }
        return stringBuffer2;
    }

    private static boolean isAllASCII(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') continue;
            bl = false;
            break;
        }
        return bl;
    }

    static {
        block2: {
            INSTANCE_TLS = new HostnameChecker(1);
            INSTANCE_LDAP = new HostnameChecker(2);
            ACE_PREFIX_LENGTH = ACE_PREFIX.length();
            namePrep = null;
            InputStream inputStream = null;
            try {
                inputStream = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        return StringPrep.class.getResourceAsStream("uidna.spp");
                    }
                }) : StringPrep.class.getResourceAsStream("uidna.spp");
                namePrep = new StringPrep(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

