/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.CryptoPrimitive;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import sun.misc.HexDumpEncoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.ParsingException;
import sun.security.timestamp.TimestampToken;
import sun.security.util.ConstraintsParameters;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.KeyUtil;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.X500Name;

public class SignerInfo
implements DerEncoder {
    private static final Set<CryptoPrimitive> DIGEST_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.MESSAGE_DIGEST));
    private static final Set<CryptoPrimitive> SIG_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    private static final DisabledAlgorithmConstraints JAR_DISABLED_CHECK = new DisabledAlgorithmConstraints("jdk.jar.disabledAlgorithms");
    BigInteger version;
    X500Name issuerName;
    BigInteger certificateSerialNumber;
    AlgorithmId digestAlgorithmId;
    AlgorithmId digestEncryptionAlgorithmId;
    byte[] encryptedDigest;
    Timestamp timestamp;
    private boolean hasTimestamp = true;
    private static final Debug debug = Debug.getInstance("jar");
    PKCS9Attributes authenticatedAttributes;
    PKCS9Attributes unauthenticatedAttributes;

    public SignerInfo(X500Name x500Name, BigInteger bigInteger, AlgorithmId algorithmId, AlgorithmId algorithmId2, byte[] byArray) {
        this.version = BigInteger.ONE;
        this.issuerName = x500Name;
        this.certificateSerialNumber = bigInteger;
        this.digestAlgorithmId = algorithmId;
        this.digestEncryptionAlgorithmId = algorithmId2;
        this.encryptedDigest = byArray;
    }

    public SignerInfo(X500Name x500Name, BigInteger bigInteger, AlgorithmId algorithmId, PKCS9Attributes pKCS9Attributes, AlgorithmId algorithmId2, byte[] byArray, PKCS9Attributes pKCS9Attributes2) {
        this.version = BigInteger.ONE;
        this.issuerName = x500Name;
        this.certificateSerialNumber = bigInteger;
        this.digestAlgorithmId = algorithmId;
        this.authenticatedAttributes = pKCS9Attributes;
        this.digestEncryptionAlgorithmId = algorithmId2;
        this.encryptedDigest = byArray;
        this.unauthenticatedAttributes = pKCS9Attributes2;
    }

    public SignerInfo(DerInputStream derInputStream) throws IOException, ParsingException {
        this(derInputStream, false);
    }

    public SignerInfo(DerInputStream derInputStream, boolean bl) throws IOException, ParsingException {
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2) {
            throw new ParsingException("Invalid length for IssuerAndSerialNumber");
        }
        byte[] byArray = derValueArray[0].toByteArray();
        this.issuerName = new X500Name(new DerValue(48, byArray));
        this.certificateSerialNumber = derValueArray[1].getBigInteger();
        DerValue derValue = derInputStream.getDerValue();
        this.digestAlgorithmId = AlgorithmId.parse(derValue);
        if (bl) {
            derInputStream.getSet(0);
        } else if ((byte)derInputStream.peekByte() == -96) {
            this.authenticatedAttributes = new PKCS9Attributes(derInputStream);
        }
        derValue = derInputStream.getDerValue();
        this.digestEncryptionAlgorithmId = AlgorithmId.parse(derValue);
        this.encryptedDigest = derInputStream.getOctetString();
        if (bl) {
            derInputStream.getSet(0);
        } else if (derInputStream.available() != 0 && (byte)derInputStream.peekByte() == -95) {
            this.unauthenticatedAttributes = new PKCS9Attributes(derInputStream, true);
        }
        if (derInputStream.available() != 0) {
            throw new ParsingException("extra data at the end");
        }
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    @Override
    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.issuerName.encode(derOutputStream2);
        derOutputStream2.putInteger(this.certificateSerialNumber);
        derOutputStream.write((byte)48, derOutputStream2);
        this.digestAlgorithmId.encode(derOutputStream);
        if (this.authenticatedAttributes != null) {
            this.authenticatedAttributes.encode((byte)-96, derOutputStream);
        }
        this.digestEncryptionAlgorithmId.encode(derOutputStream);
        derOutputStream.putOctetString(this.encryptedDigest);
        if (this.unauthenticatedAttributes != null) {
            this.unauthenticatedAttributes.encode((byte)-95, derOutputStream);
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream3.toByteArray());
    }

    public X509Certificate getCertificate(PKCS7 pKCS7) throws IOException {
        return pKCS7.getCertificate(this.certificateSerialNumber, this.issuerName);
    }

    public ArrayList<X509Certificate> getCertificateChain(PKCS7 pKCS7) throws IOException {
        boolean bl;
        X509Certificate x509Certificate = pKCS7.getCertificate(this.certificateSerialNumber, this.issuerName);
        if (x509Certificate == null) {
            return null;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate);
        X509Certificate[] x509CertificateArray = pKCS7.getCertificates();
        if (x509CertificateArray == null || x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) {
            return arrayList;
        }
        Principal principal = x509Certificate.getIssuerDN();
        int n = 0;
        block0: do {
            bl = false;
            for (int i = n; i < x509CertificateArray.length; ++i) {
                if (!principal.equals(x509CertificateArray[i].getSubjectDN())) continue;
                arrayList.add(x509CertificateArray[i]);
                if (x509CertificateArray[i].getSubjectDN().equals(x509CertificateArray[i].getIssuerDN())) {
                    n = x509CertificateArray.length;
                } else {
                    principal = x509CertificateArray[i].getIssuerDN();
                    X509Certificate x509Certificate2 = x509CertificateArray[n];
                    x509CertificateArray[n] = x509CertificateArray[i];
                    x509CertificateArray[i] = x509Certificate2;
                    ++n;
                }
                bl = true;
                continue block0;
            }
        } while (bl);
        return arrayList;
    }

    SignerInfo verify(PKCS7 pKCS7, byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            byte[] byArray2;
            ContentInfo contentInfo = pKCS7.getContentInfo();
            if (byArray == null) {
                byArray = contentInfo.getContentBytes();
            }
            Timestamp timestamp = null;
            try {
                timestamp = this.getTimestamp();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConstraintsParameters constraintsParameters = new ConstraintsParameters(timestamp);
            String string = this.getDigestAlgorithmId().getName();
            if (this.authenticatedAttributes == null) {
                byArray2 = byArray;
            } else {
                object5 = (ObjectIdentifier)this.authenticatedAttributes.getAttributeValue(PKCS9Attribute.CONTENT_TYPE_OID);
                if (object5 == null || !((ObjectIdentifier)object5).equals((Object)contentInfo.contentType)) {
                    return null;
                }
                object4 = (byte[])this.authenticatedAttributes.getAttributeValue(PKCS9Attribute.MESSAGE_DIGEST_OID);
                if (object4 == null) {
                    return null;
                }
                try {
                    JAR_DISABLED_CHECK.permits(string, constraintsParameters);
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    throw new SignatureException(certPathValidatorException.getMessage(), certPathValidatorException);
                }
                object3 = MessageDigest.getInstance(AlgorithmId.getStandardDigestName(string));
                object2 = ((MessageDigest)object3).digest(byArray);
                if (((Object)object4).length != ((Object)object2).length) {
                    return null;
                }
                for (int i = 0; i < ((Object)object4).length; ++i) {
                    if (object4[i] == object2[i]) continue;
                    return null;
                }
                byArray2 = this.authenticatedAttributes.getDerEncoding();
            }
            object5 = this.getDigestEncryptionAlgorithmId().getName();
            object4 = AlgorithmId.getEncAlgFromSigAlg((String)object5);
            if (object4 != null) {
                object5 = object4;
            }
            object3 = AlgorithmId.makeSigAlg(string, (String)object5);
            try {
                JAR_DISABLED_CHECK.permits((String)object3, constraintsParameters);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new SignatureException(certPathValidatorException.getMessage(), certPathValidatorException);
            }
            object2 = this.getCertificate(pKCS7);
            if (object2 == null) {
                return null;
            }
            PublicKey publicKey = ((Certificate)object2).getPublicKey();
            if (!JAR_DISABLED_CHECK.permits(SIG_PRIMITIVE_SET, publicKey)) {
                throw new SignatureException("Public key check failed. Disabled key used: " + KeyUtil.getKeySize(publicKey) + " bit " + publicKey.getAlgorithm());
            }
            if (object2.hasUnsupportedCriticalExtension()) {
                throw new SignatureException("Certificate has unsupported critical extension(s)");
            }
            boolean[] blArray = ((X509Certificate)object2).getKeyUsage();
            if (blArray != null) {
                try {
                    object = new KeyUsageExtension(blArray);
                }
                catch (IOException iOException) {
                    throw new SignatureException("Failed to parse keyUsage extension");
                }
                boolean bl = ((KeyUsageExtension)object).get("digital_signature");
                boolean bl2 = ((KeyUsageExtension)object).get("non_repudiation");
                if (!bl && !bl2) {
                    throw new SignatureException("Key usage restricted: cannot be used for digital signatures");
                }
            }
            object = Signature.getInstance((String)object3);
            ((Signature)object).initVerify(publicKey);
            ((Signature)object).update(byArray2);
            if (((Signature)object).verify(this.encryptedDigest)) {
                return this;
            }
        }
        catch (IOException iOException) {
            throw new SignatureException("IO error verifying signature:\n" + iOException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException("InvalidKey: " + invalidKeyException.getMessage());
        }
        return null;
    }

    SignerInfo verify(PKCS7 pKCS7) throws NoSuchAlgorithmException, SignatureException {
        return this.verify(pKCS7, null);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public X500Name getIssuerName() {
        return this.issuerName;
    }

    public BigInteger getCertificateSerialNumber() {
        return this.certificateSerialNumber;
    }

    public AlgorithmId getDigestAlgorithmId() {
        return this.digestAlgorithmId;
    }

    public PKCS9Attributes getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AlgorithmId getDigestEncryptionAlgorithmId() {
        return this.digestEncryptionAlgorithmId;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public PKCS9Attributes getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public PKCS7 getTsToken() throws IOException {
        if (this.unauthenticatedAttributes == null) {
            return null;
        }
        PKCS9Attribute pKCS9Attribute = this.unauthenticatedAttributes.getAttribute(PKCS9Attribute.SIGNATURE_TIMESTAMP_TOKEN_OID);
        if (pKCS9Attribute == null) {
            return null;
        }
        return new PKCS7((byte[])pKCS9Attribute.getValue());
    }

    public Timestamp getTimestamp() throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        if (this.timestamp != null || !this.hasTimestamp) {
            return this.timestamp;
        }
        PKCS7 pKCS7 = this.getTsToken();
        if (pKCS7 == null) {
            this.hasTimestamp = false;
            return null;
        }
        byte[] byArray = pKCS7.getContentInfo().getData();
        SignerInfo[] signerInfoArray = pKCS7.verify(byArray);
        ArrayList<X509Certificate> arrayList = signerInfoArray[0].getCertificateChain(pKCS7);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        CertPath certPath = certificateFactory.generateCertPath(arrayList);
        TimestampToken timestampToken = new TimestampToken(byArray);
        this.verifyTimestamp(timestampToken);
        this.timestamp = new Timestamp(timestampToken.getDate(), certPath);
        return this.timestamp;
    }

    private void verifyTimestamp(TimestampToken timestampToken) throws NoSuchAlgorithmException, SignatureException {
        String string = AlgorithmId.getStandardDigestName(timestampToken.getHashAlgorithm().getName());
        if (!JAR_DISABLED_CHECK.permits(DIGEST_PRIMITIVE_SET, string, null)) {
            throw new SignatureException("Timestamp token digest check failed. Disabled algorithm used: " + string);
        }
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        if (!Arrays.equals(timestampToken.getHashedMessage(), messageDigest.digest(this.encryptedDigest))) {
            throw new SignatureException("Signature timestamp (#" + timestampToken.getSerialNumber() + ") generated on " + timestampToken.getDate() + " is inapplicable");
        }
        if (debug != null) {
            debug.println();
            debug.println("Detected signature timestamp (#" + timestampToken.getSerialNumber() + ") generated on " + timestampToken.getDate());
            debug.println();
        }
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "";
        string = string + "Signer Info for (issuer): " + this.issuerName + "\n";
        string = string + "\tversion: " + Debug.toHexString(this.version) + "\n";
        string = string + "\tcertificateSerialNumber: " + Debug.toHexString(this.certificateSerialNumber) + "\n";
        string = string + "\tdigestAlgorithmId: " + this.digestAlgorithmId + "\n";
        if (this.authenticatedAttributes != null) {
            string = string + "\tauthenticatedAttributes: " + this.authenticatedAttributes + "\n";
        }
        string = string + "\tdigestEncryptionAlgorithmId: " + this.digestEncryptionAlgorithmId + "\n";
        string = string + "\tencryptedDigest: \n" + hexDumpEncoder.encodeBuffer(this.encryptedDigest) + "\n";
        if (this.unauthenticatedAttributes != null) {
            string = string + "\tunauthenticatedAttributes: " + this.unauthenticatedAttributes + "\n";
        }
        return string;
    }
}

