/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class MessageHeader {
    private String[] keys;
    private String[] values;
    private int nkeys;

    public MessageHeader() {
        this.grow();
    }

    public MessageHeader(InputStream inputStream) throws IOException {
        this.parseHeader(inputStream);
    }

    public synchronized void reset() {
        this.keys = null;
        this.values = null;
        this.nkeys = 0;
        this.grow();
    }

    public synchronized String findValue(String string) {
        if (string == null) {
            int n = this.nkeys;
            while (--n >= 0) {
                if (this.keys[n] != null) continue;
                return this.values[n];
            }
        } else {
            int n = this.nkeys;
            while (--n >= 0) {
                if (!string.equalsIgnoreCase(this.keys[n])) continue;
                return this.values[n];
            }
        }
        return null;
    }

    public synchronized int getKey(String string) {
        int n = this.nkeys;
        while (--n >= 0) {
            if (this.keys[n] != string && (string == null || !string.equalsIgnoreCase(this.keys[n]))) continue;
            return n;
        }
        return -1;
    }

    public synchronized String getKey(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.keys[n];
    }

    public synchronized String getValue(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.values[n];
    }

    public synchronized String findNextValue(String string, String string2) {
        boolean bl = false;
        if (string == null) {
            int n = this.nkeys;
            while (--n >= 0) {
                if (this.keys[n] != null) continue;
                if (bl) {
                    return this.values[n];
                }
                if (this.values[n] != string2) continue;
                bl = true;
            }
        } else {
            int n = this.nkeys;
            while (--n >= 0) {
                if (!string.equalsIgnoreCase(this.keys[n])) continue;
                if (bl) {
                    return this.values[n];
                }
                if (this.values[n] != string2) continue;
                bl = true;
            }
        }
        return null;
    }

    public boolean filterNTLMResponses(String string) {
        int n;
        boolean bl = false;
        for (n = 0; n < this.nkeys; ++n) {
            if (!string.equalsIgnoreCase(this.keys[n]) || this.values[n] == null || this.values[n].length() <= 5 || !this.values[n].regionMatches(true, 0, "NTLM ", 0, 5)) continue;
            bl = true;
            break;
        }
        if (bl) {
            n = 0;
            for (int i = 0; i < this.nkeys; ++i) {
                if (string.equalsIgnoreCase(this.keys[i]) && ("Negotiate".equalsIgnoreCase(this.values[i]) || "Kerberos".equalsIgnoreCase(this.values[i]))) continue;
                if (i != n) {
                    this.keys[n] = this.keys[i];
                    this.values[n] = this.values[i];
                }
                ++n;
            }
            if (n != this.nkeys) {
                this.nkeys = n;
                return true;
            }
        }
        return false;
    }

    public Iterator<String> multiValueIterator(String string) {
        return new HeaderIterator(string, this);
    }

    public synchronized Map<String, List<String>> getHeaders() {
        return this.getHeaders(null);
    }

    public synchronized Map<String, List<String>> getHeaders(String[] stringArray) {
        return this.filterAndAddHeaders(stringArray, null);
    }

    public synchronized Map<String, List<String>> filterAndAddHeaders(String[] stringArray, Map<String, List<String>> map) {
        boolean bl = false;
        HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>();
        int n = this.nkeys;
        while (--n >= 0) {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null || !stringArray[i].equalsIgnoreCase(this.keys[n])) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(this.keys[n]);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put(this.keys[n], arrayList);
                }
                arrayList.add(this.values[n]);
                continue;
            }
            bl = false;
        }
        if (map != null) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                ArrayList arrayList = (ArrayList)hashMap.get(entry.getKey());
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(entry.getKey(), arrayList);
                }
                arrayList.addAll(entry.getValue());
            }
        }
        for (String string : hashMap.keySet()) {
            hashMap.put(string, Collections.unmodifiableList((List)hashMap.get(string)));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public synchronized void print(PrintStream printStream) {
        for (int i = 0; i < this.nkeys; ++i) {
            if (this.keys[i] == null) continue;
            printStream.print(this.keys[i] + (this.values[i] != null ? ": " + this.values[i] : "") + "\r\n");
        }
        printStream.print("\r\n");
        printStream.flush();
    }

    public synchronized void add(String string, String string2) {
        this.grow();
        this.keys[this.nkeys] = string;
        this.values[this.nkeys] = string2;
        ++this.nkeys;
    }

    public synchronized void prepend(String string, String string2) {
        this.grow();
        for (int i = this.nkeys; i > 0; --i) {
            this.keys[i] = this.keys[i - 1];
            this.values[i] = this.values[i - 1];
        }
        this.keys[0] = string;
        this.values[0] = string2;
        ++this.nkeys;
    }

    public synchronized void set(int n, String string, String string2) {
        this.grow();
        if (n < 0) {
            return;
        }
        if (n >= this.nkeys) {
            this.add(string, string2);
        } else {
            this.keys[n] = string;
            this.values[n] = string2;
        }
    }

    private void grow() {
        if (this.keys == null || this.nkeys >= this.keys.length) {
            String[] stringArray = new String[this.nkeys + 4];
            String[] stringArray2 = new String[this.nkeys + 4];
            if (this.keys != null) {
                System.arraycopy(this.keys, 0, stringArray, 0, this.nkeys);
            }
            if (this.values != null) {
                System.arraycopy(this.values, 0, stringArray2, 0, this.nkeys);
            }
            this.keys = stringArray;
            this.values = stringArray2;
        }
    }

    public synchronized void remove(String string) {
        if (string == null) {
            for (int i = 0; i < this.nkeys; ++i) {
                while (this.keys[i] == null && i < this.nkeys) {
                    for (int j = i; j < this.nkeys - 1; ++j) {
                        this.keys[j] = this.keys[j + 1];
                        this.values[j] = this.values[j + 1];
                    }
                    --this.nkeys;
                }
            }
        } else {
            for (int i = 0; i < this.nkeys; ++i) {
                while (string.equalsIgnoreCase(this.keys[i]) && i < this.nkeys) {
                    for (int j = i; j < this.nkeys - 1; ++j) {
                        this.keys[j] = this.keys[j + 1];
                        this.values[j] = this.values[j + 1];
                    }
                    --this.nkeys;
                }
            }
        }
    }

    public synchronized void set(String string, String string2) {
        int n = this.nkeys;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(this.keys[n])) continue;
            this.values[n] = string2;
            return;
        }
        this.add(string, string2);
    }

    public synchronized void setIfNotSet(String string, String string2) {
        if (this.findValue(string) == null) {
            this.add(string, string2);
        }
    }

    public static String canonicalID(String string) {
        char c;
        int n;
        if (string == null) {
            return "";
        }
        int n2 = string.length();
        boolean bl = false;
        for (n = 0; n < n2 && ((c = string.charAt(n)) == '<' || c <= ' '); ++n) {
            bl = true;
        }
        while (n < n2 && ((c = string.charAt(n2 - 1)) == '>' || c <= ' ')) {
            --n2;
            bl = true;
        }
        return bl ? string.substring(n, n2) : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseHeader(InputStream inputStream) throws IOException {
        MessageHeader messageHeader = this;
        synchronized (messageHeader) {
            this.nkeys = 0;
        }
        this.mergeHeader(inputStream);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void mergeHeader(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        char[] cArray = new char[10];
        int n = inputStream.read();
        while (true) {
            Object object;
            void var2_3;
            int n2;
            int n3;
            block20: {
                int n4;
                boolean bl;
                if (n != 10 && n != 13 && n >= 0) {
                    n3 = 0;
                    n2 = -1;
                    bl = n > 32;
                    var2_3[n3++] = (char)n;
                } else {
                    return;
                }
                while ((n4 = inputStream.read()) >= 0) {
                    switch (n4) {
                        case 58: {
                            if (bl && n3 > 0) {
                                n2 = n3;
                            }
                            bl = false;
                            break;
                        }
                        case 9: {
                            n4 = 32;
                        }
                        case 32: {
                            bl = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            n = inputStream.read();
                            if (n4 == 13 && n == 10 && (n = inputStream.read()) == 13) {
                                n = inputStream.read();
                            }
                            if (n == 10 || n == 13 || n > 32) break block20;
                            n4 = 32;
                        }
                    }
                    if (n3 >= ((void)var2_3).length) {
                        object = new char[((void)var2_3).length * 2];
                        System.arraycopy(var2_3, 0, object, 0, n3);
                        Object object2 = object;
                    }
                    var2_3[n3++] = (char)n4;
                }
                n = -1;
            }
            while (n3 > 0 && var2_3[n3 - 1] <= 32) {
                --n3;
            }
            if (n2 <= 0) {
                object = null;
                n2 = 0;
            } else {
                object = String.copyValueOf((char[])var2_3, 0, n2);
                if (n2 < n3 && var2_3[n2] == 58) {
                    ++n2;
                }
                while (n2 < n3 && var2_3[n2] <= 32) {
                    ++n2;
                }
            }
            String string = n2 >= n3 ? new String() : String.copyValueOf((char[])var2_3, n2, n3 - n2);
            this.add((String)object, string);
        }
    }

    public synchronized String toString() {
        String string = super.toString() + this.nkeys + " pairs: ";
        for (int i = 0; i < this.keys.length && i < this.nkeys; ++i) {
            string = string + "{" + this.keys[i] + ": " + this.values[i] + "}";
        }
        return string;
    }

    class HeaderIterator
    implements Iterator<String> {
        int index = 0;
        int next = -1;
        String key;
        boolean haveNext = false;
        Object lock;

        public HeaderIterator(String string, Object object) {
            this.key = string;
            this.lock = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = this.lock;
            synchronized (object) {
                if (this.haveNext) {
                    return true;
                }
                while (this.index < MessageHeader.this.nkeys) {
                    if (this.key.equalsIgnoreCase(MessageHeader.this.keys[this.index])) {
                        this.haveNext = true;
                        this.next = this.index++;
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }
        }

        @Override
        public String next() {
            Object object = this.lock;
            synchronized (object) {
                if (this.haveNext) {
                    this.haveNext = false;
                    return MessageHeader.this.values[this.next];
                }
                if (this.hasNext()) {
                    return this.next();
                }
                throw new NoSuchElementException("No more elements");
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not allowed");
        }
    }
}

